(function ($) {
  "use strict";

  //header v1
  function headerV1($scope, $) {
    // RESPONSIVE MENU
    $('.responsive').on('click', function (e) {
      $('#mobile-menu').slideToggle();
    });

    // meanmenu
    $('#mobile-menu').meanmenu({
      meanMenuContainer: '.mobile-menu',
      meanScreenWidth: "992"
    });


    // menu toggle
    $(".main-menu li a").on('click', function () {
      if ($(window).width() < 700) {
        $("#mobile-menu").slideUp();
      }
    });
  }

  //testimonial slider one
  function testimonialSlider($scope, $) {
    if ($(".testimonial-one").length) {
      new Swiper(".testimonial-one", {
        loop: true,
        speed: 2000,
        slidesPerView: 1,
        autoplay: {
          delay: 3000,
          disableOnInteraction: false,
          pauseOnMouseEnter: true,
        },

        navigation: {
          nextEl: ".swiper-button-next",
          prevEl: ".swiper-button-prev",
        },
      });
    }
  }

  //testimonial slider two
  function testimonialSliderTwo($scope, $) {
    if ($(".testimoial-item-2").length) {
      new Swiper(".testimoial-item-2", {
        loop: true,
        speed: 2000,
        slidesPerView: 1,
        autoplay: {
          delay: 3000,
          disableOnInteraction: false,
          pauseOnMouseEnter: true,
        },

        navigation: {
          nextEl: ".swiper-button-next",
          prevEl: ".swiper-button-prev",
        },
      });
    }
  }

  //testimonial slider three
  function testimonialSliderThree($scope, $) {
    if ($(".testimoial-item-3").length) {
      new Swiper(".testimoial-item-3", {
        loop: true,
        speed: 2000,
        breakpoints: {
          768: {
            slidesPerView: 2,
          },
          1024: {
            slidesPerView: 2,
          },
        },
        autoplay: {
          delay: 3000,
          disableOnInteraction: false,
          pauseOnMouseEnter: true,
        },
        navigation: {
          nextEl: ".swiper-button-next",
          prevEl: ".swiper-button-prev",
        },
      });
    }
  }

  //counter
  function counterOdometer($scope, $) {
    if ($(".odometer").length) {
      $('.odometer').appear();
      $(document.body).on('appear', '.odometer', function () {
        $(".odometer").each(function () {
          $(this).html($(this).attr("data-count"));
        });
      });
    }
  }

  //video lightbox
  function videoLightbox($scope, $) {
    if ($(".video-btn").length) {
      $(".video-btn").on("click", function () {
        $.fancybox({
          href: this.href,
          type: $(this).data("type"),
          title: this.title,
          helpers: {
            title: { type: 'inside' },
            media: {}
          },
          beforeShow: function () {
            $(".fancybox-wrap").addClass("portfolio-fancybox");
          }
        });
        return false;
      });
    }
  }

  /*===== Initialize the Elementor editor hooks =====*/
  $(window).on("elementor/frontend/init", function () {
    if (elementorFrontend.isEditMode()) {
      elementorFrontend.hooks.addAction("frontend/element_ready/init-header-one.default", headerV1);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-testimonial-v1.default", testimonialSlider);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-testimonial-v2.default", testimonialSliderTwo);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-testimonial-v3.default", testimonialSliderThree);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-counter-v1.default", counterOdometer);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-video-lightbox.default", videoLightbox);
    }
  });

})(jQuery);
