<?php

namespace Elementor;

class Cipher_About_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-about-v1';
    }

    public function get_title(): string
    {
        return esc_html__('About V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['about', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('ABOUT US' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Elevate your brand with a the stunning portfolio' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Descrption' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => esc_html__('In embracing frontier science, our objective is to contribute to advancements that directly benefit humanity, aligning our talents with a purpose-driven of commitment to create tangible, positive outcomes.' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'item_list',
            [
                'label' => esc_html__('Feature Items' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'icon_class',
                        'label' => esc_html__('Icon Class' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('icon-sicon4' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'item_title',
                        'label' => esc_html__('Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Through this strategic shift Time.' ,'cipher-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );
        $this->end_controls_section();

        //content imgaes
        $this->start_controls_section(
            'content_section_images',
            [
                'label' => esc_html__('Images' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'left_shape_image',
            [
                'label' => esc_html__('Left Shape Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'about_image_1',
            [
                'label' => esc_html__('About Image One' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'about_image_2',
            [
                'label' => esc_html__('About Image Two' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'right_icon_image',
            [
                'label' => esc_html__('RIght Icon Class' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('icon-Global-connection---Free-networking-icons-2-1' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'exp_year_icon',
            [
                'label' => esc_html__('Experience Year Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('icon-medal' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'exp_year',
            [
                'label' => esc_html__('Experience Year' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('250+' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'exp_title',
            [
                'label' => esc_html__('Experience TItle' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Project Complete' ,'cipher-core'),
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Sub Title', '.about-right-text span');

        $cipher_init->typography_style($this, 'Title', '.about-right-text h2');

        $cipher_init->typography_style($this, 'Description', '.about-right-text p');

        $cipher_init->typography_style($this, 'Feature Item', '.about-features-item h4');
        
        $cipher_init->icon_style($this, 'Feature Item Icon', '.about-features-item i');

        $cipher_init->typography_style($this, 'Experience Year ', '.experience-text-right h3');

        $cipher_init->typography_style($this, 'Experience Title ', '.experience-text-right span');

        $cipher_init->icon_style($this, 'Experience Icon ', '.right-text i');
        
        $cipher_init->section_style($this, 'Experience Body ', '.right-text');
        
        $cipher_init->icon_style($this, 'Icon ', '.icon i');

        $cipher_init->section_style($this, 'Icon Body', '.icon');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $item_list = $settings['item_list'] ? $settings['item_list'] : [];
?>
        <section class="about-area ptb-120">
            <div class="container">
                <div class="about-wrap">
                    <div class="row">
                        <div class="col col-lg-6 col-md-12 col-12">
                            <div class="about-left-item  wow fadeInLeftSlow" data-wow-duration="1400ms">
                                <div class="about-left-top">

                                    <?php if (!empty($settings['left_shape_image']['id'])): ?>
                                        <div class="left-arrow wow fadeInRightSlow" data-wow-duration="1800ms">
                                            <?php echo wp_get_attachment_image($settings['left_shape_image']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($settings['about_image_1']['id'])): ?>
                                        <div class="right-img">
                                            <?php echo wp_get_attachment_image($settings['about_image_1']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($settings['right_icon_image'])): ?>
                                        <div class="icon">
                                            <i class="<?php echo esc_attr($settings['right_icon_image']); ?>"></i>
                                        </div>
                                    <?php endif; ?>

                                </div>
                                <div class="about-left-bottom">

                                    <?php if (!empty($settings['about_image_2']['id'])): ?>
                                        <div class="left-img wow fadeInLeftSlow" data-wow-duration="1600ms">
                                            <?php echo wp_get_attachment_image($settings['about_image_2']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>

                                    <div class="right-text">
                                        <?php if (!empty($settings['exp_year_icon'])): ?><i class="<?php echo esc_attr($settings['exp_year_icon']); ?>"></i><?php endif; ?>
                                        <?php if (!empty($settings['exp_year']) || !empty($settings['exp_title'])): ?>
                                            <div class="experience-text-right">
                                                <h3><?php echo esc_html($settings['exp_year']); ?></h3>
                                                <span><?php echo esc_html($settings['exp_title']); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col col-lg-6 col-md-12 col-12">
                            <div class="about-right-item wow fadeInRightSlow" data-wow-duration="1400ms">
                                <div class="about-right-text">
                                    <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                    <?php if (!empty($settings['title'])): ?><h2 class="site-split-text ch-split-in-right"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                                    <?php if (!empty($settings['description'])): ?><p><?php echo esc_html($settings['description']); ?></p><?php endif; ?>

                                    <div class="about-features-wrap">
                                        <div class="row">
                                            <?php
                                            if (!empty($item_list)) :
                                                foreach ($item_list as $item) :
                                            ?>
                                                    <div class="col-lg-6 col-sm-6 col-12">
                                                        <div class="about-features-item wow fadeInUp"
                                                            data-wow-duration="1400ms">
                                                            <i class="<?php echo esc_attr($item['icon_class']); ?>"></i>
                                                            <h4><?php echo esc_html($item['item_title']); ?></h4>
                                                        </div>
                                                    </div>

                                            <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_About_V1());
