<?php

namespace Elementor;

class Cipher_About_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-about-v2';
    }

    public function get_title(): string
    {
        return esc_html__('About V2', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['about', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => esc_html__('Select Style' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'style_one',
                'options' => [
                    'style_one' => esc_html__('Style One' ,'cipher-core'),
                    'style_two' => esc_html__('Style Two' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('ABOUT US' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Elevate your brand with a the stunning portfolio' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Descrption' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => esc_html__('In embracing frontier science, our objective is to contribute to advancements that directly benefit humanity, aligning our talents with a purpose-driven of commitment to create tangible, positive outcomes.' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('View More' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //content imgaes
        $this->start_controls_section(
            'content_section_images',
            [
                'label' => esc_html__('Images' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'image_one',
            [
                'label' => esc_html__('Image One' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_two',
            [
                'label' => esc_html__('Image Two' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_three',
            [
                'label' => esc_html__('Image Three' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image_one',
            [
                'label' => esc_html__('Shape Image One' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image_two',
            [
                'label' => esc_html__('Shape Image Two' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'exp_year_icon',
            [
                'label' => esc_html__('Experience Year Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('icon-medal' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'exp_year',
            [
                'label' => esc_html__('Experience Year' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('15' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'exp_title',
            [
                'label' => esc_html__('Experience TItle' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Years Of experience' ,'cipher-core'),
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Sub Title', '.about-right-text span');

        $cipher_init->typography_style($this, 'Title', '.about-right-text h2');

        $cipher_init->typography_style($this, 'Description', '.about-right-text p');

        $cipher_init->button_style($this, 'Button', '.about-right-text .ch-btn-style-3');

        $cipher_init->typography_style($this, 'Experience Year ', '.exprience-inner p');

        $cipher_init->typography_style($this, 'Experience Title ', '.exprience-inner span');

        $cipher_init->section_style($this, 'Experience Body ', '.about-area-s2 .about-left-item .about-left-img .exprience-wrap');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $select_style = $settings['select_style'];

        if ('style_two' == $select_style) {
            $order_class = 'order-2 mt-5 mt-lg-0';
        } else {
            $order_class = '';
        }
?>
        <section class="about-area-s2 ptb-120">
            <div class="container">
                <div class="about-wrap">
                    <div class="row align-items-center">
                        <div class="col col-lg-6 col-md-12 col-12  <?php echo esc_attr($order_class); ?>">
                            <div class="about-left-item  wow fadeInLeftSlow" data-wow-duration="1400ms">
                                <div class="about-left-img">
                                    <?php echo wp_get_attachment_image($settings['image_one']['id'], 'full'); ?>

                                    <div class="left-inner-img">
                                        <?php echo wp_get_attachment_image($settings['image_two']['id'], 'full'); ?>
                                        <div class="left-top-right-shape">
                                            <?php echo wp_get_attachment_image($settings['shape_image_two']['id'], 'full'); ?>
                                        </div>
                                    </div>

                                    <?php if (!empty($settings['shape_image_one']['id'])): ?>
                                        <div class="left-top-shape">
                                            <?php echo wp_get_attachment_image($settings['shape_image_one']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($settings['exp_year']) || !empty($settings['exp_title'])): ?>
                                        <div class="exprience-wrap wow fadeInUp" data-wow-duration="1600ms">
                                            <div class="exprience-inner">
                                                <p><?php echo esc_html($settings['exp_year']); ?><span><?php echo esc_html($settings['exp_title']); ?></span></p>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <?php if (!empty($settings['image_three']['id'])): ?>
                                    <div class="about-right-img">
                                        <div class="left-img wow fadeInRightSlow" data-wow-duration="1800ms">
                                            <?php echo wp_get_attachment_image($settings['image_three']['id'], 'full'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                        <div class="col col-lg-6 col-md-12 col-12">
                            <div class="about-right-item wow fadeInRightSlow" data-wow-duration="1400ms">
                                <div class="about-right-text">
                                    <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                    <?php if (!empty($settings['title'])): ?><h2 class="site-split-text ch-split-in-right"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                                    <?php if (!empty($settings['description'])): ?><p><?php echo esc_html($settings['description']); ?></p><?php endif; ?>
                                    <?php if (!empty($settings['btn_title'])): ?><a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="ch-btn-style-3 ch-btn-animated"><?php echo esc_html($settings['btn_title']); ?></a><?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_About_V2());
