<?php

namespace Elementor;

class Cipher_About_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-about-v3';
    }

    public function get_title(): string
    {
        return esc_html__('About V3', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['about', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('ABOUT US' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Elevate your brand with a the stunning portfolio' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Descrption' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => esc_html__('In embracing frontier science, our objective is to contribute to advancements that directly benefit humanity, aligning our talents with a purpose-driven of commitment to create tangible, positive outcomes.' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('View More' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'item_list',
            [
                'label' => esc_html__('Feature Items' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'item_info',
                        'label' => esc_html__('Info' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('3K' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'item_title',
                        'label' => esc_html__('Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Winning award' ,'cipher-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );
        $this->end_controls_section();

        //content imgaes
        $this->start_controls_section(
            'content_section_images',
            [
                'label' => esc_html__('Images' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'image_1',
            [
                'label' => esc_html__('Image One' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_2',
            [
                'label' => esc_html__('Image Two' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_3',
            [
                'label' => esc_html__('Image Three' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Sub Title', '.about-right-text span');

        $cipher_init->typography_style($this, 'Title', '.about-right-text h2');

        $cipher_init->typography_style($this, 'Description', '.about-right-text p');

        $cipher_init->button_style($this, 'Button', '.ch-btn-style-3');

        $cipher_init->typography_style($this, 'Feature Info', '.funfact-item h3');

        $cipher_init->typography_style($this, 'Feature Title', '.funfact-item p');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $item_list = $settings['item_list'] ? $settings['item_list'] : [];
?>
        <section class="about-area-s2 ptb-120">
            <div class="container">
                <div class="about-wrap">
                    <div class="row align-items-center">
                        <div class="col col-lg-6 col-md-12 col-12">
                            <div class="about-left-item  wow fadeInLeftSlow" data-wow-duration="1400ms">

                                <?php if (!empty($settings['image_1']['id'])): ?>
                                    <div class="about-left-img">
                                        <?php echo wp_get_attachment_image($settings['image_1']['id'], 'full', false, array('class' => 'imageParallax')); ?>
                                    </div>
                                <?php endif; ?>

                                <div class="about-right-img">
                                    <div class="left-img wow fadeInRightSlow" data-wow-duration="1800ms">
                                        <?php if (!empty($settings['image_3']['id'])): ?><div class="star"><?php echo wp_get_attachment_image($settings['image_3']['id'], 'full'); ?></div><?php endif; ?>
                                        <?php echo wp_get_attachment_image($settings['image_2']['id'], 'full', false, array('class' => 'imageParallax4')); ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col col-lg-6 col-md-12 col-12">
                            <div class="about-right-item wow fadeInRightSlow" data-wow-duration="1400ms">
                                <div class="about-right-text">

                                    <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                    <?php if (!empty($settings['title'])): ?><h2 class="site-split-text ch-split-in-right"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                                    <?php if (!empty($settings['description'])): ?><p><?php echo esc_html($settings['description']); ?></p><?php endif; ?>
                                    <?php if (!empty($settings['btn_title'])): ?><a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="ch-btn-style-3 ch-btn-animated"><?php echo esc_html($settings['btn_title']); ?></a><?php endif; ?>

                                    <?php if (!empty($item_list)) : ?>
                                        <div class="about-funfact wow fadeInUp" data-wow-duration="1600ms" style="visibility: visible; animation-duration: 1600ms; animation-name: fadeInUp;">
                                            <?php foreach ($item_list as $item) : ?>
                                                <div class="funfact-item">
                                                    <?php if (!empty($item['item_info'])): ?><h3><?php echo esc_html($item['item_info']); ?></h3><?php endif; ?>
                                                    <?php if (!empty($item['item_title'])): ?><p><?php echo esc_html($item['item_title']); ?></p><?php endif; ?>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_About_V3());
