<?php

namespace Elementor;

class Cipher_Award extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-award';
    }

    public function get_title(): string
    {
        return esc_html__('Award', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['award', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('About The Event' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('Main Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('portfolios' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Nulla vitae ex nunc. Morbi quis purus convallis, fermentum metus volutpat, sodales purus. Nunc quis mauris et eros vulputNulla vitae ex nunc. Morbi quis purus convallis, fermentum metus' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_txt',
            [
                'label' => esc_html__('Butttn Text' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('View now' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'award_list',
            [
                'label' => esc_html__('Award List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'award_title',
                        'label' => esc_html__('Award Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Award Title' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'award_date',
                        'label' => esc_html__('Award Date' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Awards &nbsp; 2016' ,'cipher-core'),
                        'show_label' => false,
                    ],
                    [
                        'name' => 'award_link',
                        'label' => esc_html__('Award Link' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ award_title }}}',
            ]
        );

        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section', '.company-area');

        $cipher_init->typography_style($this, 'Sub Title', '.ch-top-title-s3 span');

        $cipher_init->typography_style($this, 'Title', '.ch-top-title-s3 h2');

        $cipher_init->typography_style($this, 'Description', '.ch-top-title-s3 p');

        $cipher_init->button_style($this, 'Button', '.ch-btn-style-2');

        $cipher_init->typography_style($this, 'Award Title', '.comapny-item-info h4');

        $cipher_init->typography_style($this, 'Award Date', '.comapny-item-info span');

        $cipher_init->section_style($this, 'Award Body', '.comapny-item');

        $cipher_init->section_style($this, 'Award Body Hover', '.company-area .company-wrap .comapny-item:hover::before');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $award_list = $settings['award_list'] ? $settings['award_list'] : [];
?>
        <section class="company-area ptb-120">
            <div class="container">
                <div class="company-wrap">
                    <div class="row justify-content-center">
                        <div class="col-lg-6">
                            <div class="ch-top-title-s3">
                                <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                <?php if (!empty($settings['main_title'])): ?><h2 class="site-split-text ch-split-in-right"><?php echo esc_html($settings['main_title']); ?></h2><?php endif; ?>
                                <?php if (!empty($settings['description'])): ?><p><?php echo esc_html($settings['description']); ?></p><?php endif; ?>
                                <?php if (!empty($settings['btn_txt'])): ?><a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="ch-btn-style-2"><?php echo esc_html($settings['btn_txt']); ?></a><?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-6">

                            <?php
                            if (!empty($award_list)) :
                                foreach ($award_list as $award) : ?>
                                    <a href="<?php echo esc_url($award['award_link']['url']); ?>" class="comapny-item">
                                        <div class="comapny-item-info">
                                            <?php if (!empty($award['award_title'])): ?><h4><?php echo esc_html($award['award_title']); ?></h4><?php endif; ?>
                                            <?php if (!empty($award['award_date'])): ?><span><?php echo wp_kses_post($award['award_date']); ?></span><?php endif; ?>
                                        </div>
                                        <small>
                                            <i class="icon-arrow"></i>
                                        </small>
                                    </a>
                            <?php
                                endforeach;
                            endif;
                            ?>

                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Award());
