<?php

namespace Elementor;

class Cipher_Blog_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-blog-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Blog V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['blog-v1', 'blog', 'cipher'];
    }

    protected function register_controls(): void
    {
        //text slider
        $this->start_controls_section(
            'content_section_text_slider',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_post',
            [
                'label' => esc_html__('Select Post' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => cipher_get_blog(),
            ]
        );
        $this->add_control(
            'featured_image',
            [
                'label' => esc_html__('Featured Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('Show Author' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show' ,'cipher-core'),
                'label_off' => esc_html__('Hide' ,'cipher-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('Show Date' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show' ,'cipher-core'),
                'label_off' => esc_html__('Hide' ,'cipher-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_excerpt',
            [
                'label' => esc_html__('Show Excerpt' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show' ,'cipher-core'),
                'label_off' => esc_html__('Hide' ,'cipher-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'excerpt_length',
            [
                'label' => esc_html__('Excerpt Length' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 5,
                'condition' => [
                    'show_excerpt' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Read More' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => esc_html__('Animation Delay (ms)' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 300,
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Title', '.blog-content h2 a');

        $cipher_init->typography_style($this, 'Description', '.blog-content .desc');

        $cipher_init->typography_style($this, 'Author ', '.blog-content .author');

        $cipher_init->typography_style($this, 'Date', '.blog-content .date');

        $cipher_init->button_style($this, 'Button', '.ch-btn-style-3');

        $cipher_init->icon_style($this, 'Icon', '.blog-content ul li i');

        $cipher_init->section_style($this, 'Post Body', '.ch-blog-item');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $excerpt_length = !empty($settings['excerpt_length']) ? $settings['excerpt_length'] : 5;
        $postId = $settings['select_post'] ? intval($settings['select_post']) : 0;
        $title = wp_trim_words(get_post_field('post_title', $postId), 10, '...');
        $date = get_the_date('', $postId);
        $author = get_the_author_meta('display_name', get_post_field('post_author', $postId));
        $permalink = get_permalink($postId);
        $excerpt_lenght = wp_trim_words(get_post_field('post_content', $postId), $excerpt_length, '...');
        $description = $excerpt_lenght ? $excerpt_lenght : '';

?>
        <div class="ch-blog-item wow fadeInUp" data-wow-delay="<?php echo esc_attr($settings['animation_delay']); ?>ms" data-wow-duration="1200ms">

            <?php if (!empty($settings['featured_image']['id'])): ?>
                <div class="blog-img-left">
                    <div class="blog-img">
                        <?php echo wp_get_attachment_image($settings['featured_image']['id'], 'full'); ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="blog-content">
                <ul>
                    <?php if ('yes' == $settings['show_author']): ?><li class="author"><i class="icon-user"></i><?php echo esc_html($author) ?></li><?php endif; ?>
                    <?php if ('yes' == $settings['show_date']): ?><li class="date"><i class="icon-calender"></i><?php echo esc_html($date) ?></li><?php endif; ?>
                </ul>
                <h2><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title) ?></a>
                </h2>
                <?php if ('yes' == $settings['show_excerpt']): ?><div class="desc mb-3"><?php echo wp_kses_post($description); ?></div class="desc"><?php endif; ?>
                <?php if (!empty($settings['btn_title'])): ?><a href="<?php echo esc_url($permalink); ?>" class="ch-btn-style-3 ch-btn-animated"><?php echo esc_html($settings['btn_title']); ?></a><?php endif; ?>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Blog_V1());
