<?php

namespace Elementor;

class Cipher_Blog_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-blog-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Blog V2', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['blog-v2', 'blog', 'cipher'];
    }

    protected function register_controls(): void
    {
        //text slider
        $this->start_controls_section(
            'content_section_',
            [
                'label' => esc_html__('Content', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('About The Event', 'cipher-core'),
            ]
        );
        $this->add_control(
            'before_title',
            [
                'label' => esc_html__('Before Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Captivating', 'cipher-core'),
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('Main Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('portfolios', 'cipher-core'),
            ]
        );
        $this->add_control(
            'after_title',
            [
                'label' => esc_html__('After Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('that lasting impression', 'cipher-core'),
            ]
        );
        $this->add_control(
            'shape_image',
            [
                'label' => esc_html__('Shape Image', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        //posts
        $this->start_controls_section(
            'content_section_post_slider',
            [
                'label' => esc_html__('Posts', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'posts_list',
            [
                'label' => esc_html__('Repeater List', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'select_post',
                        'label' => esc_html__('Select Post', 'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '-1',
                        'options' => cipher_get_blog(),
                    ],
                    [
                        'name' => 'featured_img',
                        'label' => esc_html__('Featured Image', 'cipher-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name'  => 'show_author',
                        'label' => esc_html__('Show Author', 'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => esc_html__('Show', 'cipher-core'),
                        'label_off' => esc_html__('Hide', 'cipher-core'),
                        'return_value' => 'yes',
                        'default' => 'yes',
                    ],
                    [
                        'name'  => 'show_date',
                        'label' => esc_html__('Show Date', 'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => esc_html__('Show', 'cipher-core'),
                        'label_off' => esc_html__('Hide', 'cipher-core'),
                        'return_value' => 'yes',
                        'default' => 'yes',
                    ],
                    [
                        'name' => 'show_excerpt',
                        'label' => esc_html__('Show Excerpt', 'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => esc_html__('Show', 'cipher-core'),
                        'label_off' => esc_html__('Hide', 'cipher-core'),
                        'return_value' => 'yes',
                        'default' => 'yes',
                    ],
                    [
                        'name' => 'excerpt_length',
                        'label' => esc_html__('Excerpt Length', 'cipher-core'),
                        'type' => \Elementor\Controls_Manager::NUMBER,
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                        'default' => 5,
                        'condition' => [
                            'show_excerpt' => 'yes',
                        ],
                    ],
                    [
                        'name'   => 'btn_title',
                        'label' => esc_html__('Button Title', 'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Read More', 'cipher-core'),
                    ],
                    [
                        'name'  => 'ani_duration',
                        'label' => esc_html__('Animation Duration (ms)', 'cipher-core'),
                        'type' => \Elementor\Controls_Manager::NUMBER,
                        'min' => 0,
                        'step' => 100,
                        'default' => 300,
                    ]
                ],
                'title_field' => '{{{ select_post.title }}}',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section', '.ch-blog-area-s2');

        $cipher_init->typography_style($this, 'Sub Title', '.ch-top-title-s2 span');

        $cipher_init->typography_style($this, 'Title', '.ch-top-title-s2 h2');

        $cipher_init->typography_style($this, 'Blog Title', '.blog-content h2 a');

        $cipher_init->typography_style($this, 'Blog Description', '.blog-content p');

        $cipher_init->typography_style($this, 'Blog Author ', '.blog-content ul .author ');

        $cipher_init->typography_style($this, 'Blog Date ', '.blog-content ul .date ');

        $cipher_init->button_style($this, 'Button', '.ch-btn-style-3');

        $cipher_init->section_style($this, 'Post Body', '.blog-item');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $posts_list  = $settings['posts_list'] ? $settings['posts_list'] : [];

?>
        <section class="ch-blog-area-s2 ptb-120">
            <div class="container">

                <?php if ($settings['sub_title'] || $settings['before_title'] || $settings['main_title'] || $settings['after_title']): ?>
                    <div class="row justify-content-center">
                        <div class="col-xl-6 col-lg-6 col-12">
                            <div class="ch-top-title-s2">
                                <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                <h2 class="site-split-text ch-split-in-up"><?php echo esc_html($settings['before_title']); ?> <small><?php echo esc_html($settings['main_title']); ?></small> <?php echo esc_html($settings['after_title']); ?></h2>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="blog-items">
                    <div class="row">

                        <?php
                        if (!empty($posts_list)) :
                            foreach ($posts_list as $post_item) :
                                $postId = $post_item['select_post'] ? intval($post_item['select_post']) : 0;
                                $title = wp_trim_words(get_post_field('post_title', $postId), 10, '...');
                                $date = get_the_date('', $postId);
                                $author = get_the_author_meta('display_name', get_post_field('post_author', $postId));
                                $permalink = get_permalink($postId);
                                $excerpt_length = !empty($post_item['excerpt_length']) ? $post_item['excerpt_length'] : 5;
                                $excerpt_lenght = wp_trim_words(get_post_field('post_content', $postId), $excerpt_length, '...');
                                $description = $excerpt_lenght ? $excerpt_lenght : '';
                        ?>
                                <div class="col col-xl-4 col-lg-12 col-md-12 col-12">
                                    <div class="blog-item wow fadeInUp" data-wow-duration="<?php echo esc_attr($post_item['ani_duration']); ?>ms">
                                        <div class="blog-img-left">
                                            <div class="blog-img">
                                                <?php
                                                if (!empty($post_item['featured_img']['id'])) {
                                                    echo wp_get_attachment_image($post_item['featured_img']['id'], 'full');
                                                }
                                                ?>
                                            </div>
                                        </div>
                                        <div class="blog-content">
                                            <ul>
                                                <?php if ('yes' == $post_item['show_author']): ?><li class="author"><i class="icon-user"></i> <?php echo esc_html($author); ?></li><?php endif; ?>
                                                <?php if ('yes' == $post_item['show_date']): ?><li class="date"><i class="icon-calender"></i> <?php echo esc_html($date); ?></li><?php endif; ?>
                                            </ul>
                                            <h2><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title); ?></a></h2>
                                            <?php if ('yes' == $post_item['show_excerpt']): ?><p><?php echo wp_kses_post($description); ?></p><?php endif; ?>
                                            <?php if (!empty($post_item['btn_title'])): ?><a href="<?php echo esc_url($permalink); ?>" class="ch-btn-style-3 ch-btn-animated"><?php echo esc_html($post_item['btn_title']); ?></a><?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            endforeach;
                        endif;
                        ?>

                    </div>
                </div>
            </div> <!-- end container -->

            <?php if (!empty($settings['shape_image']['id'])): ?>
                <div class="left-shape">
                    <?php echo wp_get_attachment_image($settings['shape_image']['id'], 'full'); ?>
                </div>
            <?php endif; ?>

        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Blog_V2());
