<?php

namespace Elementor;

class Cipher_Breadcrumb extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-breadcrumb';
    }

    public function get_title(): string
    {
        return esc_html__('Breadcrumb', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['breadrumb', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'bc_title',
            [
                'label' => esc_html__('Page Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Default title' ,'cipher-core'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'bc_background',
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .page-title:before',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section Style', '.page-title');

        $cipher_init->typography_style($this, 'Title', '.breadcumb-wrap h2');

        $cipher_init->typography_style($this, 'Item ', '.breadcumb-wrap ol li span a span');

        $cipher_init->typography_style($this, 'Item Active', '.page-title .breadcumb-wrap ol li .current-item');

        $cipher_init->icon_style($this, 'Separator', '.page-title .breadcumb-wrap ol li i');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $bc_title = $settings['bc_title'] ? $settings['bc_title'] : '';
?>

        <section class="page-title">
            <div class="container">
                <div class="row">
                    <div class="col col-xs-12">
                        <div class="breadcumb-wrap">
                            <?php if (!empty($bc_title)): ?><h2 class="site-split-text ch-split-in-right"> <?php echo esc_html($bc_title); ?></h2><?php endif; ?>
                            <?php if (function_exists('bcn_display')) : ?>
                                <ol>
                                    <li>
                                        <?php
                                        if (function_exists('bcn_display')) {
                                            bcn_display();
                                        }
                                        ?>
                                    </li>
                                </ol>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Breadcrumb());
