<?php

namespace Elementor;

class Cipher_Buttons extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-buttons';
    }

    public function get_title(): string
    {
        return esc_html__('Buttons', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['buttons', 'button', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Style' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'button_style',
            [
                'label' => esc_html__('Select Style' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'btn-01',
                'options' => [
                    'btn-01' => esc_html__('Style One' ,'cipher-core'),
                    'btn-02' => esc_html__('Style Two' ,'cipher-core'),
                    'btn-03' => esc_html__('Style Three' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Read More' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $CipherElementorInit = \Cipher_Elementor_Widget_Init::getInstance();
        $CipherElementorInit->button_style($this, 'Style One', '.ch-btn-style-1');
        $CipherElementorInit->button_style($this, 'Style Two', '.ch-btn-style-2');
        $CipherElementorInit->button_style($this, 'Style Three', '.ch-btn-style-3, .cp-header-area .cp-header-area-right .call-btn');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $button_style = $settings['button_style'];

?>
        <?php if ('btn-01' == $button_style && !empty($settings['btn_title'])): ?>
            <a href="<?php echo esc_url($settings['btn_link']['url']) ?>" class="ch-btn-style-1 ch-btn-animated"><?php echo esc_html($settings['btn_title']); ?></a>
        <?php endif; ?>

        <?php if ('btn-02' == $button_style && !empty($settings['btn_title'])): ?>
            <a href="<?php echo esc_url($settings['btn_link']['url']) ?>" class="ch-btn-style-2"><?php echo esc_html($settings['btn_title']); ?></a>
        <?php endif; ?>

        <?php if ('btn-03' == $button_style && !empty($settings['btn_title'])): ?>
            <div class="cp-header-area">
                <div class="cp-header-area-right">
                    <a href="<?php echo esc_url($settings['btn_link']['url']) ?>" class="call-btn"><i class="icon-Group-7042"></i><span><?php echo esc_html($settings['btn_title']); ?></span></a>
                </div>
            </div>
        <?php endif; ?>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Buttons());
