<?php

namespace Elementor;

class Cipher_Card_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-card-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Card V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['card', 'card-v1', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon_style',
            [
                'label' => esc_html__('Icon Style' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'icon_class' => esc_html__('Icon Class' ,'cipher-core'),
                    'icon' => esc_html__('Icon' ,'cipher-core'),
                    'image' => esc_html__('Image' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            '_icon_class',
            [
                'label' => esc_html__('Icon Class' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('icon-wordpress-logo' ,'cipher-core'),
                'description' => esc_html__('It Print Inside I Tag Like: <i class="icon-creative"></i>' ,'cipher-core'),
                'condition' => [
                    'icon_style' => 'icon_class',
                ],
            ]
        );
        $this->add_control(
            '_icon',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
                'condition' => [
                    'icon_style' => 'icon',
                ],
            ]
        );
        $this->add_control(
            '_image',
            [
                'label' => esc_html__('Choose Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_style' => 'image',
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Wordpress' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => esc_html__('Nulla vitae ex nunc.quis purus convallis, fermentum me volutpat, sodales purus. Nunc quis mauris' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => esc_html__('Animation Delay' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('400' ,'cipher-core'),
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Title', '.skill-text h3');

        $cipher_init->typography_style($this, 'Description', '.skill-text p');

        $cipher_init->section_style($this, 'Card Body', '.ch-skill-card');

        $cipher_init->icon_style($this, 'Icon', '.skill-icon i');

        $cipher_init->section_style($this, 'Icon Body', '.skill-icon');

        $this->start_controls_section(
            'content_section_icon_body_postion',
            [
                'label' => esc_html__('Icon Body Position' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'top_position',
            [
                'label' => esc_html__('Top Position' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ch-skill-card .skill-icon' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'left_position',
            [
                'label' => esc_html__('Left Position' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ch-skill-card .skill-icon' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();

?>

        <div class="ch-skill-card wow fadeInUp" data-wow-delay="<?php echo esc_attr($settings['animation_delay']); ?>ms" data-wow-duration="1000ms">
            <?php if (!empty($settings['_icon']) || !empty($settings['_image']) || !empty($settings['_icon_class'])) : ?>
                <div class="skill-icon">
                    <?php
                    if ($settings['icon_style'] === 'icon') :
                        \Elementor\Icons_Manager::render_icon($settings['_icon'], ['aria-hidden' => 'true']);
                    elseif ($settings['icon_style'] === 'image') :
                    ?>
                        <img src="<?php echo esc_url($settings['_image']['url']); ?>" alt="<?php echo esc_attr($settings['title']); ?>">
                    <?php
                    else :
                        echo '<i class="' . esc_attr($settings['_icon_class']) . '"></i>';
                    endif;
                    ?>
                </div>
            <?php endif; ?>
            <div class="skill-text">
                <?php if (!empty($settings['title'])): ?><h3><?php echo esc_html($settings['title']); ?></h3><?php endif ?>
                <?php if (!empty($settings['description'])): ?><p><?php echo esc_html($settings['description']); ?></p><?php endif ?>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Card_V1());
