<?php

namespace Elementor;

class Cipher_Contact_Form extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-contact-form';
    }

    public function get_title(): string
    {
        return esc_html__('Contact Form', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['contact', 'contact-form', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__('Form Shortcode' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('[contact-form-7 id="b35b75f" title="Contact form one"]' ,'cipher-core'),
                'description' => esc_html__('Example: [contact-form-7 id="b35b75f" title="Contact form one"]', 'textdomin')
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Body', '.contact-form-area');

        $cipher_init->button_style($this, 'Submit Button', '.ch-btn-style-2');

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .contact-form-area form input, .contact-form-area form select, .contact-form-area form textarea',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-form-area form select, .contact-form-area form input::placeholder, .contact-form-area form select::placeholder, .contact-form-area form textarea::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-form-area form input, .contact-form-area form select, .contact-form-area form textarea' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .contact-form-area form input, .contact-form-area form select, .contact-form-area form textarea',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .contact-form-area form input, .contact-form-area form select, .contact-form-area form textarea',
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>

        <?php if (!empty($settings['form_shortcode'])): ?>
            <div class="contact-form-area">
                <div class="contact-activation" id="contact-form-mejor">
                    <?php echo do_shortcode($settings['form_shortcode']); ?>
                </div>
            </div>
        <?php endif; ?>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Contact_Form());
