<?php

namespace Elementor;

class Cipher_Counter_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-counter-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Counter V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['counter', 'counter-v1', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'number_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('200' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'number',
            [
                'label' => esc_html__('Number' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('200' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'number_suffix',
            [
                'label' => esc_html__('Number Suffix' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('+' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'animation_delay',
            [
                'label' => esc_html__('Animation Delay' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('400' ,'cipher-core'),
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Title', '.ch-info p');

        $cipher_init->typography_style($this, 'Number', '.ch-info h3');

        $cipher_init->section_style($this, 'Counter Body', '.ch-info');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();

?>
        <div class="ch-info wow fadeInUp" data-wow-delay="<?php echo esc_attr($settings['animation_delay']); ?>ms" data-wow-duration="1000ms">
            <?php if (!empty($settings['number_title'])): ?><p><?php echo esc_html($settings['number_title']); ?></p><?php endif; ?>
            <h3><span class="odometer" data-count="<?php echo esc_attr($settings['number']); ?>">00</span><?php echo esc_html($settings['number_suffix']); ?></h3>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Counter_V1());
