<?php

namespace Elementor;

class Cipher_Event_Card extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-event-card';
    }

    public function get_title(): string
    {
        return esc_html__('Event Card', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['event-card', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('About The Event' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'before_title',
            [
                'label' => esc_html__('Before Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Captivating' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('Main Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('portfolios' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'after_title',
            [
                'label' => esc_html__('After Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('that lasting impression' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_txt',
            [
                'label' => esc_html__('Butttn Text' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('View now' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .about-event-area .event-wrap:before',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section', '.event-wrap');

        $cipher_init->typography_style($this, 'Sub Title', '.ch-top-title span');

        $cipher_init->typography_style($this, 'Title', '.ch-top-title h2');

        $cipher_init->button_style($this, 'Button', '.ch-btn-style-1');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();

?>

        <section class="about-event-area">
            <div class="container">
                <div class="event-wrap">
                    <div class="row justify-content-center">
                        <div class="col-lg-6">
                            <div class="ch-top-title">
                                <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                <h2 class="site-split-text ch-split-in-up"><?php echo esc_html($settings['before_title']); ?> <small><?php echo esc_html($settings['main_title']); ?></small> <?php echo esc_html($settings['after_title']); ?></h2>
                                <?php if (!empty($settings['btn_txt'])): ?><a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="ch-btn-style-1 ch-btn-animated"><?php echo esc_html($settings['btn_txt']); ?></a><?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Event_Card());
