<?php

namespace Elementor;

class Footer_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-footer-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Footer V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_hf_widgets'];
    }

    public function get_keywords(): array
    {
        return ['footer-v1', 'footer', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'logo_image',
            [
                'label' => esc_html__('Logo Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__('Lorem Ipsum is simply is dumiomy is text Lorem Ipsum is simply' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'social_icon_list',
            [
                'label' => esc_html__('Social Icon list' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => '_icon',
                        'label' => esc_html__('Icon' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                    [
                        'name' => '_link',
                        'label' => esc_html__('Link' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ _link.title }}}',
            ]
        );
        $this->end_controls_section();

        // Menu Section
        $this->start_controls_section(
            'content_section_menu',
            [
                'label' => esc_html__('Menu' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'menu_main_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Our Services' ,'cipher-core'),
            ]
        );

        $this->add_control(
            'menu_item_list',
            [
                'label' => esc_html__('Menu list' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'menu_title',
                        'label' => esc_html__('Menu Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Default title' ,'cipher-core'),
                    ],
                    [
                        'name' => 'menu_link',
                        'label' => esc_html__('Menu Link' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ menu_title }}}',
            ]
        );
        $this->end_controls_section();

        // address Section
        $this->start_controls_section(
            'content_section_address',
            [
                'label' => esc_html__('Address' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'address_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Address' ,'cipher-core'),
            ]
        );

        $this->add_control(
            'address_list',
            [
                'label' => esc_html__('Address list' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'add_title',
                        'label' => esc_html__('Address Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('(629) 555-0129' ,'cipher-core'),
                    ],
                    [
                        'name' => 'add_icon',
                        'label' => esc_html__('Icon' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                    ],
                    [
                        'name' => 'add_link',
                        'label' => esc_html__('Link' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ add_title }}}',
            ]
        );
        $this->end_controls_section();

        // Menu Section
        $this->start_controls_section(
            'content_section_newsletter',
            [
                'label' => esc_html__('Newsletter' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'newsletter_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Get Free Estimate' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'newsletter_shortcode',
            [
                'label' => esc_html__('Shortcode' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('[contact-form-7 id="3d25d75" title="Footer One Newsletter"]' ,'cipher-core'),
            ]
        );
        $this->end_controls_section();


        //copyright area
        $this->start_controls_section(
            'content_section_copyright',
            [
                'label' => esc_html__('Copyright' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'copyright_title',
            [
                'label' => esc_html__('Copyright Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Address' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'copyright_menu_list',
            [
                'label' => esc_html__('Copyright Menu' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'copy_menu_title',
                        'label' => esc_html__('Menu Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Terms & Condition' ,'cipher-core'),
                    ],
                    [
                        'name' => 'copy_menu_link',
                        'label' => esc_html__('Link' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]
                ],
                'title_field' => '{{{ copy_menu_title }}}',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Footer Body', '.footer-section');

        $cipher_init->typography_style($this, 'Description', '.desc');

        $cipher_init->typography_style($this, 'Menu, Address, Newsletter Title', '.widget-title h3');

        $cipher_init->icon_style($this, 'Social Icon', '.social-widget ul li a');

        $cipher_init->icon_style($this, 'Social Icon Hover', '.social-widget ul li:hover a');

        $cipher_init->typography_style($this, 'Menu Item', '.menu-item ul li a');

        $cipher_init->typography_style($this, 'Address Item', '.contact-ft ul li a');

        $cipher_init->icon_style($this, 'Address Icon', '.contact-ft ul li i');

        $cipher_init->typography_style($this, 'Copyright Text', '.copyright');

        $cipher_init->typography_style($this, 'Copyright Menu', '.lower-footer-link li a');

        $cipher_init->section_style($this, 'Copyright Body', '.footer-section .lower-footer .row');

        $cipher_init->button_style($this, 'Newsleter Button', '.footer-section .subscribe .form-field button');

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Newsletter Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .footer-section .subscribe .form-field input',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-section .subscribe .form-field input::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-section .subscribe .form-field input' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .footer-section .subscribe .form-field input',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .footer-section .subscribe .form-field input',
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $social_icon_list = $settings['social_icon_list'] ? $settings['social_icon_list'] : [];
        $menu_item_list = $settings['menu_item_list'] ? $settings['menu_item_list'] : [];
        $address_list = $settings['address_list'] ? $settings['address_list'] : [];
        $copyright_menu_list = $settings['copyright_menu_list'] ? $settings['copyright_menu_list'] : [];
?>
        <footer class="footer-section">
            <div class="upper-footer">
                <div class="container">
                    <div class="row">
                        <div class="col col-lg-3 col-md-6 col-sm-12 col-12">
                            <div class="widget about-widget">

                                <?php if (!empty($settings['logo_image']['id'])): ?>
                                    <div class="logo widget-title">
                                        <a href="<?php echo esc_url(home_url('/')); ?>">
                                            <?php echo wp_get_attachment_image($settings['logo_image']['id'], 'full'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($settings['description'])): ?><p class="desc"><?php echo esc_html($settings['description']); ?></p><?php endif; ?>

                                <?php if (!empty($social_icon_list)): ?>
                                    <div class="widget social-widget p-0">
                                        <ul>
                                            <?php
                                            foreach ($social_icon_list as $item) {
                                                $this->add_render_attribute('icon_link', 'href', esc_url($item['_link']['url']));
                                                if ($item['_link']['is_external']) {
                                                    $this->add_render_attribute('icon_link', 'target', '_blank');
                                                }
                                                if ($item['_link']['nofollow']) {
                                                    $this->add_render_attribute('icon_link', 'rel', 'nofollow');
                                                }
                                                echo '<li><a ' . $this->get_render_attribute_string('icon_link') . '>';
                                                echo '<i class="' . esc_attr($item['_icon']['library'] . ' ' . esc_attr($item['_icon']['value'])) . '"></i>';
                                                echo '</a></li>';
                                            };
                                            ?>
                                        </ul>
                                    </div>
                                <?php endif ?>

                            </div>
                        </div>
                        <div class="col col-xl-3 col-lg-2 col-md-6 col-sm-12 col-12">
                            <div class="widget link-widget menu-item">

                                <?php if (!empty($settings['menu_main_title'])): ?>
                                    <div class="widget-title">
                                        <h3><?php echo esc_html($settings['menu_main_title']); ?></h3>
                                    </div>
                                <?php endif; ?>

                                <ul>
                                    <?php
                                    if (!empty($menu_item_list)) {
                                        foreach ($menu_item_list as $item) {
                                            $this->add_render_attribute('menu_link', 'href', esc_url($item['menu_link']['url']));
                                            if ($item['menu_link']['is_external']) {
                                                $this->add_render_attribute('menu_link', 'target', '_blank');
                                            }
                                            if ($item['menu_link']['nofollow']) {
                                                $this->add_render_attribute('menu_link', 'rel', 'nofollow');
                                            }
                                            echo '<li><a ' . $this->get_render_attribute_string('menu_link') . '>' . esc_html($item['menu_title']) . '</a></li>';
                                        }
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col col-lg-3 col-md-6 col-sm-12 col-12">
                            <div class="widget contact-widget">

                                <?php if (!empty($settings['address_title'])): ?>
                                    <div class="widget-title">
                                        <h3><?php echo esc_html($settings['address_title']); ?></h3>
                                    </div>
                                <?php endif; ?>

                                <div class="contact-ft">
                                    <ul>
                                        <?php
                                        if (!empty($address_list)) {
                                            foreach ($address_list as $item) {
                                                $this->add_render_attribute('add_link', 'href', esc_url($item['add_link']['url']));
                                                if ($item['add_link']['is_external']) {
                                                    $this->add_render_attribute('add_link', 'target', '_blank');
                                                }
                                                if ($item['add_link']['nofollow']) {
                                                    $this->add_render_attribute('add_link', 'rel', 'nofollow');
                                                }
                                                echo '<li><i class="' . esc_attr($item['add_icon']['library'] . ' ' . esc_attr($item['add_icon']['value'])) . '"></i><a ' . $this->get_render_attribute_string('add_link') . '>' . esc_html($item['add_title']) . '</a></li>';
                                            }
                                        }
                                        ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col col-xl-3 col-lg-3 col-md-6 col-sm-12 col-12">
                            <div class="widget subscribe">

                                <?php if (!empty($settings['newsletter_title'])): ?>
                                    <div class="widget-title">
                                        <h3><?php echo esc_html($settings['newsletter_title']); ?></h3>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($settings['newsletter_shortcode'])): ?>
                                    <div action="#">
                                        <?php echo do_shortcode($settings['newsletter_shortcode']); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div> <!-- end container -->
            </div>
            <div class="lower-footer">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col col-lg-6 col-12">
                            <div class="copy-right">
                                <div class="copyright">
                                    <?php
                                    if (!empty($settings['copyright_title'])) {
                                        echo wp_kses_post($settings['copyright_title']);
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col col-lg-6 col-12">
                            <ul class="lower-footer-link">
                                <?php
                                if (!empty($copyright_menu_list)) {
                                    foreach ($copyright_menu_list as $item) {
                                        $this->add_render_attribute('copy_menu_link', 'href', esc_url($item['copy_menu_link']['url']));
                                        if ($item['copy_menu_link']['is_external']) {
                                            $this->add_render_attribute('copy_menu_link', 'target', '_blank');
                                        }
                                        if ($item['copy_menu_link']['nofollow']) {
                                            $this->add_render_attribute('copy_menu_link', 'rel', 'nofollow');
                                        }
                                        echo '<li><a ' . $this->get_render_attribute_string('copy_menu_link') . '>' . esc_html($item['copy_menu_title']) . '</a></li>';
                                    }
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Footer_V1());
