<?php

namespace Elementor;

class Header_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-header-one';
    }

    public function get_title(): string
    {
        return esc_html__('Header V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_hf_widgets'];
    }

    public function get_keywords(): array
    {
        return ['header-one', 'menu', 'header', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => esc_html__('Select Style' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'one',
                'options' => [
                    'style_one' => esc_html__('Style One' ,'cipher-core'),
                    'style_two' => esc_html__('Style Two' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'h1_header_style',
            [
                'label' => esc_html__('Select Menu', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'header-1',
                'label_block' => true,
                'options' => cipher_menu_selector(),
            ]
        );
        $this->add_control(
            'logo_image',
            [
                'label' => esc_html__('Logo Image', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Whatsapp:(208) 555-0112', 'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Btton Link', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();


        // Cipher_Elementor_Widget_Init instance
        $tElementorInit = \Cipher_Elementor_Widget_Init::getInstance();

        $tElementorInit->typography_style($this, 'Menu', '.il-main-navigation a, .il-main-navigation ul .menu-item-has-children::after');

        $tElementorInit->button_style($this, 'Button', '.cp-header-area-right .call-btn');

        $tElementorInit->button_style($this, 'Togger Icon', '.mean-container a.meanmenu-reveal');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $select_style  = $settings['select_style'];

        if ($select_style == 'style_two') {
            $class_name = 'position-relative';
        } else {
            $class_name = ' ';
        }
?>
        <header class="cp-header-area cp-header-style-1 <?php echo esc_attr($class_name); ?>">
            <div id="cp-header-sticky" class="menu-area">
                <div class="container">
                    <div class="second-menu">
                        <div class="row align-items-center">
                            <div class="col-xl-2 col-lg-2 col-md-7 col-7">
                                <?php if (!empty($settings['logo_image']['id'])): ?>
                                    <div class="logo">
                                        <a href="<?php echo esc_url(home_url('/')); ?>" class="header-logo">
                                            <?php echo wp_get_attachment_image($settings['logo_image']['id'], 'full'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-xl-7 col-lg-7 col-md-1 col-1 text-right text-xl-right">
                                <div class="main-menu">
                                    <nav id="mobile-menu" class="il-main-navigation">
                                        <?php
                                        wp_nav_menu(array(
                                            'menu'        => $settings['h1_header_style'],
                                            'menu_id' => 'main-nav',
                                            'link_before' => '<span>',
                                            'link_after' => '</span>',
                                            'container' => false,
                                            'fallback_cb' => 'Cipher_Bootstrap_Navwalker::fallback',
                                        ));
                                        ?>
                                    </nav>
                                </div>
                            </div>
                            <?php if (!empty($settings['btn_title'])): ?>
                                <div class="col-xl-3 col-lg-3 col-md-4 col-4 text-left">
                                    <div class="cp-header-area-right">
                                        <a href="<?php echo esc_html($settings['btn_link']['url']); ?>" class="call-btn"><i class="icon-Group-7042"></i><span><?php echo esc_html($settings['btn_title']); ?></span></a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="col-12">
                                <div class="mobile-menu"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>



<?php
    }
}
Plugin::instance()->widgets_manager->register(new Header_V1());
