<?php

namespace Elementor;

class Cipher_Heading extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-heading';
    }

    public function get_title(): string
    {
        return esc_html__('Heading', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['heading', 'title', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Sub Title', 'cipher-core'),
            ]
        );
        $this->add_control(
            'sub_title_tag',
            [
                'label' => esc_html__('Sub Title Tag', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'cipher-core'),
                        'icon' => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'cipher-core'),
                        'icon' => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'cipher-core'),
                        'icon' => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'cipher-core'),
                        'icon' => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'cipher-core'),
                        'icon' => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'cipher-core'),
                        'icon' => 'eicon-editor-h6',
                    ],
                    'span' => [
                        'title' => esc_html__('span', 'cipher-core'),
                        'icon' => 'eicon-editor-code',
                    ],
                ],
                'default' => 'span',
                'toggle' => true,
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'before_title',
            [
                'label' => esc_html__('Before Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Before Title', 'cipher-core'),
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('Main Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Main Title', 'cipher-core'),
            ]
        );
        $this->add_control(
            'after_title',
            [
                'label' => esc_html__('After Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Before Title', 'cipher-core'),
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title Tag', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'cipher-core'),
                        'icon' => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'cipher-core'),
                        'icon' => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'cipher-core'),
                        'icon' => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'cipher-core'),
                        'icon' => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'cipher-core'),
                        'icon' => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'cipher-core'),
                        'icon' => 'eicon-editor-h6',
                    ],
                ],
                'default' => 'h2',
                'toggle' => true,
            ]
        );
        $this->add_control(
            'animation_style',
            [
                'label' => esc_html__('Animation Style' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'animation-one',
                'options' => [
                    'default' => esc_html__('Default' ,'cipher-core'),
                    'animation-one' => esc_html__('Animation One' ,'cipher-core'),
                    'animation-two' => esc_html__('Animation Two' ,'cipher-core'),
                ],
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $CipherElementorInit = \Cipher_Elementor_Widget_Init::getInstance();
        $CipherElementorInit->typography_style($this, 'Sub Title', '.ch-sub-title');
        $CipherElementorInit->typography_style($this, 'Title', '.ch-title');
        $CipherElementorInit->typography_style($this, 'Main Title', '.ch-title small');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $sub_title_tag = isset($settings['sub_title_tag']) ? $settings['sub_title_tag'] : 'h2';
        $tag = isset($settings['title_tag']) ? $settings['title_tag'] : 'h2';
        $animation_style = isset($settings['animation_style']) ? $settings['animation_style'] : 'animation-one';

        if ('animation-one' === $animation_style) {
            $style_class = 'site-split-text ch-split-in-right';
        } elseif ('animation-two' === $animation_style) {
            $style_class = 'site-split-text ch-split-in-up';
        } elseif ('default' === $animation_style) {
            $style_class = '';
        } else {
            $style_class = '';
        }

        if (!empty($settings['sub_title'])) {
            echo '<' . esc_html($sub_title_tag) . ' class="ch-sub-title">' . esc_html($settings['sub_title']) . '</' . esc_html($sub_title_tag) . '>';
        }

        if (!empty($settings['before_title'])) {
?>
            <<?php echo esc_html($tag); ?> class="ch-title <?php echo esc_attr($style_class) ?>"><?php echo esc_html($settings['before_title']); ?> <?php if (!empty($settings['main_title'])) { ?><small><?php echo esc_html($settings['main_title']); ?></small><?php }; echo $settings['after_title'] ?></<?php echo esc_html($tag); ?>>
<?php
        }
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Heading());
