<?php

namespace Elementor;

class Hero_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-hero-one';
    }

    public function get_title(): string
    {
        return esc_html__('Section Hero V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['header-one', 'header', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Courtney Henry', 'cipher-core'),
            ]
        );
        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Lorem ipsum dolor sit amet consectetur. Amet lectus Lorem ipsum dolor sit amet consectetur. Amet lectus mi ultricies dictum facilisis the sem. Imperdiet massa turpis sit proin..', 'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_one_title',
            [
                'label' => esc_html__('Button One Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Read More', 'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_one_link',
            [
                'label' => esc_html__('Button One Link', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_two_title',
            [
                'label' => esc_html__('Button Two Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Read More', 'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_two_link',
            [
                'label' => esc_html__('Button Two Link', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .ch-main-hero::before',
            ]
        );
        $this->end_controls_section();

        //eperience content
        $this->start_controls_section(
            'content_section_exprience',
            [
                'label' => esc_html__('Exprience Years' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_exp',
            [
                'label' => esc_html__('Show Experience' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show' ,'cipher-core'),
                'label_off' => esc_html__('Hide' ,'cipher-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'exp_years',
            [
                'label' => esc_html__('Experience Years' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('25+' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'exp_title',
            [
                'label' => esc_html__('Experience Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Years of experience' ,'cipher-core'),
            ]
        );
        $this->end_controls_section();

        //text slider
        $this->start_controls_section(
            'content_section_text_slider',
            [
                'label' => esc_html__('Text Slider' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'list',
            [
                'label' => esc_html__('Text List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_title',
                        'label' => esc_html__('Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('WEB DESIGNER' ,'cipher-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Title', '.ch-main-hero-text h2');

        $cipher_init->typography_style($this, 'Description', '.ch-main-hero-text p');

        $cipher_init->button_style($this, 'Button One', '.ch-btn-style-2');

        $cipher_init->button_style($this, 'Button Two', '.ch-btn-style-1');

        $cipher_init->typography_style($this, 'Slider Text', '.content h1 span');

        $cipher_init->section_style($this, 'Slider Body', '.text-moving-sec .text-moving');

        $this->start_controls_section(
            'exp_section',
            [
                'label' => esc_html__('Expricence Body' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'exp_bg_color',
            [
                'label' => esc_html__('Background' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .poligon-wrap svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $list = $settings['list'] ? $settings['list'] : [];
?>
        <section class="ch-main-hero">
            <div class="container">
                <div class="ch-main-hero-wrap">
                    <div class="row align-items-center">
                        <div class="col-xl-10 col-lg-10 col-12">
                            <div class="ch-main-hero-text">
                                <?php if (!empty($settings['title'])): ?><h2 class="site-split-text ch-split-in-left"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                                <?php if (!empty($settings['desc'])): ?><p class="wow fadeInUp" data-wow-duration="1400ms"><?php echo esc_html($settings['desc']) ?></p><?php endif; ?>
                                <div class="hero-btn wow fadeInUp" data-wow-duration="1600ms">
                                    <?php if (!empty($settings['btn_one_title'])): ?><a href="<?php echo esc_url($settings['btn_one_link']['url']); ?>" class="ch-btn-style-2"><?php echo esc_html($settings['btn_one_title']); ?></a><?php endif; ?>
                                    <?php if (!empty($settings['btn_two_title'])): ?><a href="<?php echo esc_url($settings['btn_two_link']['url']); ?>" class="ch-btn-style-1 ch-btn-animated"><?php echo esc_html($settings['btn_two_title']); ?></a><?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php if (!empty($settings['image']['id'])): ?>
                            <div class="col-xl-9 col-lg-10">
                                <div class="right-image">
                                    <div class="right-image-mask wow fadeInUp" data-wow-duration="1200ms">
                                        <?php echo wp_get_attachment_image($settings['image']['id'], 'full'); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if ('yes' === $settings['show_exp']) : ?>
                        <div class="poligon-wrap wow zoomIn" data-wow-duration="1200ms">
                            <svg xmlns="http://www.w3.org/2000/svg" width="198" height="198" viewBox="0 0 198 198"
                                fill="none">
                                <path d="M98.5 7L177.741 52.75V144.25L98.5 190L19.2587 144.25V52.75L98.5 7Z"
                                    fill="#F1F45D" />
                                <path
                                    d="M94.9946 2.3125C95.1327 2.55165 95.4385 2.63358 95.6776 2.49551L99 0.57735L102.322 2.49551C102.562 2.63358 102.867 2.55165 103.005 2.3125L109.284 5.9375C109.146 6.17665 109.228 6.48244 109.467 6.62051L116.612 10.7455C116.851 10.8836 117.157 10.8016 117.295 10.5625L123.573 14.1875C123.435 14.4266 123.517 14.7324 123.756 14.8705L130.901 18.9955C131.14 19.1336 131.446 19.0516 131.584 18.8125L137.863 22.4375C137.725 22.6766 137.807 22.9824 138.046 23.1205L145.191 27.2455C145.43 27.3836 145.736 27.3016 145.874 27.0625L152.152 30.6875C152.014 30.9266 152.096 31.2324 152.335 31.3705L159.48 35.4955C159.719 35.6336 160.025 35.5516 160.163 35.3125L166.442 38.9375C166.304 39.1766 166.386 39.4824 166.625 39.6205L173.769 43.7455C174.009 43.8836 174.314 43.8016 174.452 43.5625L180.731 47.1875C180.593 47.4266 180.675 47.7324 180.914 47.8705L184.237 49.7887V53.625C184.237 53.9011 184.46 54.125 184.737 54.125V61.375C184.46 61.375 184.237 61.5989 184.237 61.875V70.125C184.237 70.4011 184.46 70.625 184.737 70.625V77.875C184.46 77.875 184.237 78.0989 184.237 78.375V86.625C184.237 86.9011 184.46 87.125 184.737 87.125V94.375C184.46 94.375 184.237 94.5989 184.237 94.875V103.125C184.237 103.401 184.46 103.625 184.737 103.625V110.875C184.46 110.875 184.237 111.099 184.237 111.375V119.625C184.237 119.901 184.46 120.125 184.737 120.125V127.375C184.46 127.375 184.237 127.599 184.237 127.875V136.125C184.237 136.401 184.46 136.625 184.737 136.625V143.875C184.46 143.875 184.237 144.099 184.237 144.375V148.211L180.914 150.129C180.675 150.268 180.593 150.573 180.731 150.812L174.452 154.438C174.314 154.198 174.009 154.116 173.769 154.254L166.625 158.379C166.386 158.518 166.304 158.823 166.442 159.062L160.163 162.688C160.025 162.448 159.719 162.366 159.48 162.504L152.335 166.629C152.096 166.768 152.014 167.073 152.152 167.312L145.874 170.938C145.736 170.698 145.43 170.616 145.191 170.754L138.046 174.879C137.807 175.018 137.725 175.323 137.863 175.562L131.584 179.188C131.446 178.948 131.14 178.866 130.901 179.004L123.756 183.129C123.517 183.268 123.435 183.573 123.573 183.812L117.295 187.438C117.157 187.198 116.851 187.116 116.612 187.254L109.467 191.379C109.228 191.518 109.146 191.823 109.284 192.062L103.005 195.688C102.867 195.448 102.562 195.366 102.322 195.504L99 197.423L95.6776 195.504C95.4385 195.366 95.1327 195.448 94.9946 195.688L88.716 192.062C88.854 191.823 88.7721 191.518 88.5329 191.379L81.3882 187.254C81.1491 187.116 80.8433 187.198 80.7052 187.438L74.4265 183.812C74.5646 183.573 74.4827 183.268 74.2435 183.129L67.0988 179.004C66.8597 178.866 66.5539 178.948 66.4158 179.188L60.1371 175.562C60.2752 175.323 60.1932 175.018 59.9541 174.879L52.8094 170.754C52.5702 170.616 52.2645 170.698 52.1264 170.938L45.8477 167.312C45.9858 167.073 45.9038 166.768 45.6647 166.629L38.52 162.504C38.2808 162.366 37.975 162.448 37.837 162.688L31.5583 159.062C31.6963 158.823 31.6144 158.518 31.3753 158.379L24.2306 154.254C23.9914 154.116 23.6856 154.198 23.5475 154.438L17.2689 150.812C17.4069 150.573 17.325 150.268 17.0858 150.129L13.7635 148.211V144.375C13.7635 144.099 13.5396 143.875 13.2635 143.875V136.625C13.5396 136.625 13.7635 136.401 13.7635 136.125V127.875C13.7635 127.599 13.5396 127.375 13.2635 127.375V120.125C13.5396 120.125 13.7635 119.901 13.7635 119.625V111.375C13.7635 111.099 13.5396 110.875 13.2635 110.875V103.625C13.5396 103.625 13.7635 103.401 13.7635 103.125V94.875C13.7635 94.5989 13.5396 94.375 13.2635 94.375V87.125C13.5396 87.125 13.7635 86.9011 13.7635 86.625V78.375C13.7635 78.0989 13.5396 77.875 13.2635 77.875V70.625C13.5396 70.625 13.7635 70.4011 13.7635 70.125V61.875C13.7635 61.5989 13.5396 61.375 13.2635 61.375V54.125C13.5396 54.125 13.7635 53.9011 13.7635 53.625V49.7887L17.0858 47.8705C17.325 47.7324 17.4069 47.4266 17.2689 47.1875L23.5475 43.5625C23.6856 43.8016 23.9914 43.8836 24.2306 43.7455L31.3753 39.6205C31.6144 39.4824 31.6963 39.1766 31.5583 38.9375L37.837 35.3125C37.975 35.5516 38.2808 35.6336 38.52 35.4955L45.6647 31.3705C45.9038 31.2324 45.9858 30.9266 45.8477 30.6875L52.1264 27.0625C52.2644 27.3016 52.5702 27.3836 52.8094 27.2455L59.9541 23.1205C60.1932 22.9824 60.2752 22.6766 60.1371 22.4375L66.4158 18.8125C66.5539 19.0516 66.8597 19.1336 67.0988 18.9955L74.2435 14.8705C74.4827 14.7324 74.5646 14.4266 74.4265 14.1875L80.7052 10.5625C80.8433 10.8016 81.1491 10.8836 81.3882 10.7455L88.5329 6.62051C88.7721 6.48244 88.854 6.17665 88.716 5.9375L94.9946 2.3125Z"
                                    stroke="#E9D275" stroke-linecap="round" stroke-dasharray="8 8" />
                            </svg>
                            <div class="poligon-text">
                                <i class="icon-Group"></i>
                                <div class="poligon-text-right">
                                    <?php if (!empty($settings['exp_years'])): ?><h3><?php echo esc_html($settings['exp_years']); ?></h3><?php endif; ?>
                                    <?php if (!empty($settings['exp_title'])): ?><span><?php echo esc_html($settings['exp_title']); ?></span><?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>

        <?php if (!empty($list)): ?>
            <div class="text-moving-sec">
                <div class="text-moving">
                    <div class="marquee">
                        <div class="track">
                            <div class="content">
                                <h1>
                                    <?php
                                    foreach ($list as $item) {
                                        echo '<span>' . esc_html($item['list_title']) . '</span>';
                                    }
                                    ?>
                                </h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Hero_V1());
