<?php

namespace Elementor;

class Hero_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-hero-two';
    }

    public function get_title(): string
    {
        return esc_html__('Section Hero V2', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['header-two', 'header', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('I,AM', 'cipher-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Courtney Henry', 'cipher-core'),
            ]
        );
        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('Lorem ipsum dolor sit amet consectetur. Amet lectus Lorem ipsum dolor sit amet consectetur. Amet lectus mi ultricies dictum facilisis the sem. Imperdiet massa turpis sit proin..', 'cipher-core'),
            ]
        );
        $this->end_controls_section();

        //funfact list
        $this->start_controls_section(
            'content_section_funfact',
            [
                'label' => esc_html__('Funfact' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'funfact_list',
            [
                'label' => esc_html__('Funfact List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'funfact_number',
                        'label' => esc_html__('Number' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('200+' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'funfact_title',
                        'label' => esc_html__('Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Team member' ,'cipher-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ funfact_number }}}',
            ]
        );
        $this->end_controls_section();

        //images
        $this->start_controls_section(
            'content_section_images',
            [
                'label' => esc_html__('Image' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'circle_Text',
            [
                'label' => esc_html__('Circle Text' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('1997 Best Working Since' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'icon_selector',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'icon_class' => esc_html__('Icon Class' ,'cipher-core'),
                    'icon' => esc_html__('Icon' ,'cipher-core'),
                    'image' => esc_html__('Image' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'icon_class',
            [
                'label' => esc_html__('Icon Class' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('icon-sicon6' ,'cipher-core'),
                'description' => esc_html('Example: <i class"icomoon-phone"></i>', 'cipher-core'),
                'condition' => [
                    'icon_selector' => 'icon_class',
                ],
            ]
        );
        $this->add_control(
            '_icon',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
                'condition' => [
                    'icon_selector' => 'icon',
                ],
            ]

        );
        $this->add_control(
            '_image',
            [
                'label' => esc_html__('Main Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_selector' => 'image',
                ],
            ]
        );
        $this->add_control(
            'main_image',
            [
                'label' => esc_html__('Main Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'line_image',
            [
                'label' => esc_html__('Line Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        //heading list
        $this->start_controls_section(
            'content_section_heading',
            [
                'label' => esc_html__('Heading List' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'heading_list',
            [
                'label' => esc_html__('Heading List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => '_heading',
                        'label' => esc_html__('Heading' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('GRAPHIC DESINGNER' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => '_link',
                        'label' => esc_html__('Link' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ],
                    [
                        'name' => 'animation_delay',
                        'label' => esc_html__('Animaiton Delay (MS)' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::NUMBER,
                        'min' => 100,
                        'max' => 10000000,
                        'step' => 100,
                        'default' => 300,
                    ],
                    [
                        'name' => 'animation_dutaion',
                        'label' => esc_html__('Animaiton Duration (MS)' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::NUMBER,
                        'min' => 100,
                        'max' => 10000000,
                        'step' => 100,
                        'default' => 300,
                    ],
                ],
                'title_field' => '{{{ _heading }}}',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Sub Title', '.title-sub');

        $cipher_init->typography_style($this, 'Title', '.main-title');

        $cipher_init->typography_style($this, 'Description', '.ch-main-hero-text p');

        $cipher_init->typography_style($this, 'Funfact Number', '.funfact-item h3');

        $cipher_init->typography_style($this, 'Funfact Text', '.funfact-item p');

        $cipher_init->typography_style($this, 'Cricle Text', '.rotate-text svg text textPath');

        $cipher_init->typography_style($this, 'Heading List', '.right-link ul li a');

        $cipher_init->typography_style($this, 'Heading List Hover', '.right-link ul li a:hover');

        $cipher_init->section_style($this, 'Image', '.ch-main-hero-s2 .right-image .right-image-mask:before');

        $cipher_init->icon_style($this, 'Image Icon', '.rotate-text-wrap .icon i');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $funfact_list = $settings['funfact_list'] ? $settings['funfact_list'] : [];
        $heading_list = $settings['heading_list'] ? $settings['heading_list'] : [];
?>
        <section class="ch-main-hero-s2">
            <div class="container">
                <div class="ch-main-hero-wrap">
                    <div class="row align-items-center">
                        <div class="col-xl-6 col-lg-6 col-12">
                            <div class="ch-main-hero-text">
                                <?php if (!empty($settings['sub_title'])): ?><span class="title-sub wow fadeInUp" data-wow-duration="1200ms"><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>

                                <?php if (!empty($settings['title'])): ?><h2 class="main-title site-split-text ch-split-in-left"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>

                                <?php if (!empty($settings['desc'])): ?><p class="wow fadeInUp" data-wow-duration="1400ms"><?php echo esc_html($settings['desc']) ?></p><?php endif; ?>

                                <?php if (!empty($funfact_list)) : ?>
                                    <div class="hero-funfact wow fadeInUp" data-wow-duration="1600ms">
                                        <?php foreach ($funfact_list as $funfact) : ?>
                                            <div class="funfact-item">
                                                <h3><?php echo esc_html($funfact['funfact_number']); ?></h3>
                                                <p><?php echo esc_html($funfact['funfact_title']); ?></p>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-6">
                            <div class="right-image">

                                <?php if (!empty($settings['main_image']['id'])): ?>
                                    <div class="right-image-mask wow rotateInDownRight" data-wow-duration="1000ms">
                                        <div class="h-img wow fadeInUp" data-wow-duration="2000ms">
                                            <?php echo wp_get_attachment_image($settings['main_image']['id'], 'full'); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($settings['line_image']['id'])): ?>
                                    <div class="line wow rotateInDownLeft" data-wow-duration="3000ms">
                                        <?php echo wp_get_attachment_image($settings['line_image']['id'], 'full'); ?>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($settings['circle_Text'])): ?>
                                    <div class="rotate-text-wrap wow zoomIn" data-wow-duration="1200ms">
                                        <div class="rotate-text text-roted">
                                            <svg width="200" height="200">
                                                <path fill="white"
                                                    d="M0,100a100,100 0 1,0 200,0a100,100 0 1,0 -200,0" />
                                                <path fill="none" id="innerCircle"
                                                    d="M10,100a90,90 0 1,0 180,0a90,90 0 1,0 -180,0" />
                                                <text fill="white">
                                                    <textPath xmlns:xlink="http://www.w3.org/1999/xlink"
                                                        xlink:href="#innerCircle" class="qr--label">
                                                        <?php echo esc_html($settings['circle_Text']); ?>
                                                    </textPath>
                                                </text>
                                            </svg>
                                        </div>
                                        <div class="icon">
                                            <?php
                                            if ($settings['icon_selector'] == 'icon_class' && !empty($settings['icon_class'])) : ?>
                                                <i class="<?php echo esc_attr($settings['icon_class']); ?>"></i>
                                            <?php elseif ($settings['icon_selector'] == 'icon' && !empty($settings['_icon'])) :
                                                echo '<i class="' . esc_attr($settings['_icon']['library'] . ' ' . $settings['_icon']['value']) . '"></i>';
                                            elseif ($settings['icon_selector'] == 'image' && !empty($settings['_image']['id'])) : ?>
                                                <?php echo wp_get_attachment_image($settings['_image']['id'], 'full'); ?>
                                            <?php endif;
                                            ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                    <?php if (!empty($heading_list)): ?>
                        <div class="right-link">
                            <ul>
                                <?php foreach ($heading_list as $heading) :  ?>
                                    <li class="wow fadeInRightSlow" data-wow-delay="<?php echo esc_attr($heading['animation_delay']); ?>" data-wow-duration="<?php echo esc_attr($heading['animation_dutaion']); ?>ms"><a href="<?php echo esc_url($heading['_link']['url']); ?>"><?php echo esc_html($heading['_heading']); ?></a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Hero_V2());
