<?php

namespace Elementor;

class Hero_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-hero-three';
    }

    public function get_title(): string
    {
        return esc_html__('Section Hero V3', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['header-three', 'header', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('We Are Digital Agency', 'cipher-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Top-Tier Innovative Digital', 'cipher-core'),
            ]
        );
        $this->add_control(
            'after_title',
            [
                'label' => esc_html__('After Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Agency', 'cipher-core'),
            ]
        );
        $this->add_control(
            'after_title_image',
            [
                'label' => esc_html__('After Title Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'hero_image',
            [
                'label' => esc_html__('Hero Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'after_hero_image',
            [
                'label' => esc_html__('After Hero Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Read More', 'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //images
        $this->start_controls_section(
            'content_section_images',
            [
                'label' => esc_html__('Images' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'image_one',
            [
                'label' => esc_html__('Image One' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_two',
            [
                'label' => esc_html__('Image Two' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_three',
            [
                'label' => esc_html__('Image Three' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_four',
            [
                'label' => esc_html__('Image Four' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section', '.ch-main-hero-s3');

        $cipher_init->typography_style($this, 'Sub Title', '.title-sub');

        $cipher_init->typography_style($this, 'Title', '.site-split-text');

        $cipher_init->section_style($this, 'Title Background', '.ch-main-hero-s3 .ch-main-hero-text h2 small');

        $cipher_init->button_style($this, 'Button', '.ch-btn-style-1');

    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="ch-main-hero-s3">
            <div class="container">
                <div class="ch-main-hero-wrap">
                    <div class="row align-items-center">
                        <div class="col-xl-12 col-lg-12 col-12">
                            <div class="ch-main-hero-text">
                                <?php if (!empty($settings['sub_title'])): ?><span class="title-sub"><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>

                                <?php if (!empty($settings['title'])): ?>
                                    <h2 class="site-split-text ch-split-in-left"><?php echo esc_html($settings['title']); ?>
                                        <small><?php echo esc_html($settings['after_title']); ?> <i><?php echo wp_get_attachment_image($settings['after_title_image']['id'], 'full') ?></i></small>
                                    </h2>
                                <?php endif; ?>

                                <div class="hero-img">
                                    <?php echo wp_get_attachment_image($settings['hero_image']['id'], 'full') ?>

                                    <?php if (!empty($settings['after_hero_image']['id'])): ?>
                                        <div class="star2">
                                            <?php echo wp_get_attachment_image($settings['after_hero_image']['id'], 'full') ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($settings['btn_title'])): ?>
                                        <div class="hero-btn">
                                            <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="ch-btn-style-1 ch-btn-animated"><?php echo esc_html($settings['btn_title']); ?></a>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if (!empty($settings['image_one']['id'])): ?>
                <div class="rotate-star">
                    <?php echo wp_get_attachment_image($settings['image_one']['id'], 'full'); ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($settings['image_two']['id'])): ?>
                <div class="line-shape">
                    <?php echo wp_get_attachment_image($settings['image_two']['id'], 'full'); ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($settings['image_three']['id'])): ?>
                <div class="dot-shape-1">
                    <?php echo wp_get_attachment_image($settings['image_three']['id'], 'full'); ?>
                </div>
            <?php endif; ?>

            <?php if (!empty($settings['image_four']['id'])): ?>
                <div class="dot-shape-2">
                    <?php echo wp_get_attachment_image($settings['image_four']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Hero_V3());
