<?php

namespace Elementor;

class Hero_V4 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-hero-four';
    }

    public function get_title(): string
    {
        return esc_html__('Section Hero V4', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['header-four', 'header', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Transforming Ideas into Result', 'cipher-core'),
            ]
        );
        $this->add_control(
            'title_bottom',
            [
                'label' => esc_html__('Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Corporate', 'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Read More', 'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        //images
        $this->start_controls_section(
            'content_section_images',
            [
                'label' => esc_html__('Images' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'image_one',
            [
                'label' => esc_html__('Image One' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_two',
            [
                'label' => esc_html__('Image Two' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image',
            [
                'label' => esc_html__('Shape Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        //rating
        $this->start_controls_section(
            'content_section_rating',
            [
                'label' => esc_html__('Rating', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'rating_title',
            [
                'label' => esc_html__('Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('TOP RATED ON CLUTCH', 'cipher-core'),
            ]
        );
        $this->add_control(
            'rating_number',
            [
                'label' => esc_html__('Rating Number', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('9.8', 'cipher-core'),
            ]
        );
        $this->add_control(
            'rating_text',
            [
                'label' => esc_html__('Rating Text', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Rating', 'cipher-core'),
            ]
        );
        $this->add_control(
            'rating_desc',
            [
                'label' => esc_html__('Rating Description', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Rating', 'cipher-core'),
            ]
        );
        $this->end_controls_section();

        //video
        $this->start_controls_section(
            'content_section_video',
            [
                'label' => esc_html__('Video', 'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'video_title',
            [
                'label' => esc_html__('Video Title', 'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('WachVedio', 'cipher-core'),
            ]
        );
        $this->add_control(
            'video_link',
            [
                'label' => esc_html__('Video Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();


        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section', '.ch-main-hero-s4');

        $cipher_init->typography_style($this, 'Title', '.ch-main-hero-text h2');

        $cipher_init->typography_style($this, 'Title Bttom', '.visible-text h2');

        $cipher_init->button_style($this, 'Button', '.ch-main-hero-text .hero-btn .ch-btn-style-1');

        $cipher_init->typography_style($this, 'Rating Title', '.right-rating span');

        $cipher_init->typography_style($this, 'Rating Number', '.right-rating h3');

        $cipher_init->typography_style($this, 'Rating Text', '.right-rating h3 small');

        $cipher_init->typography_style($this, 'Rating Description', '.right-rating p');

        $cipher_init->section_style($this, 'Rating Body', '.right-rating');

        $cipher_init->typography_style($this, 'Video Title', '.video-wrap span');

        $cipher_init->icon_style($this, 'Video Button', '.ch-main-hero-s4 .video-wrap .video-btn');
    }
    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>

        <section class="ch-main-hero-s4">
            <div class="container">
                <div class="ch-main-hero-wrap">
                    <div class="row">
                        <div class="col-xl-6 col-lg-5 col-12">
                            <div class="ch-main-hero-text">
                                <?php if (!empty($settings['title'])): ?><h2 class="site-split-text ch-split-in-left"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>

                                <?php if (!empty($settings['btn_title'])): ?>
                                    <div class="hero-btn wow fadeInUp" data-wow-duration="1600ms">
                                        <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="ch-btn-style-1 ch-btn-animated"><?php echo esc_html($settings['btn_title']); ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-8">
                            <div class="right-image">
                                <div class="right-image-mask wow fadeInRightSlow" data-wow-duration="1000ms">

                                    <?php if (!empty($settings['image_two']['id'])): ?>
                                        <div class="h-img wow fadeInRightSlow" data-wow-duration="2000ms">
                                            <?php echo wp_get_attachment_image($settings['image_two']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if (!empty($settings['image_one']['id'])): ?>
                                        <div class="back-bg">
                                            <?php echo wp_get_attachment_image($settings['image_one']['id'], 'full'); ?>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <?php if (!empty($settings['video_link']['url'])) : ?>
                            <div class="col-xl-2 col-lg-3 col-md-4">
                                <div class="right-rating wow fadeInDown" data-wow-duration="2000ms">
                                    <?php if (!empty($settings['rating_title'])): ?><span><?php echo esc_html($settings['rating_title']) ?></span><?php endif; ?>
                                    <h3><?php echo esc_html($settings['rating_number']) ?> <small><?php echo esc_html($settings['rating_text']) ?></small></h3>
                                    <?php if (!empty($settings['rating_desc'])): ?><p><?php echo esc_html($settings['rating_desc']) ?></p><?php endif; ?>
                                </div>
                                <div class="video-wrap wow fadeInUp" data-wow-duration="2000ms">
                                    <div class="video-btns">
                                        <a href="<?php echo esc_url($settings['video_link']['url']); ?>" class="video-btn"
                                            data-type="iframe"></a>
                                    </div>
                                    <?php if (!empty($settings['video_title'])): ?><span><?php echo esc_html($settings['video_title']); ?></span><?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if (!empty($settings['title_bottom'])): ?>
                    <div class="visible-text wow fadeInUp" data-wow-duration="2000ms">
                        <h2><?php echo esc_html($settings['title_bottom']); ?></h2>
                    </div>
                <?php endif; ?>

            </div>
            <?php if (!empty($settings['shape_image']['id'])): ?><div class="line-shape"><?php echo wp_get_attachment_image($settings['shape_image']['id'], 'full'); ?></div><?php endif; ?>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Hero_V4());
