<?php

namespace Elementor;

class Cipher_Icon_Box extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-icon-box';
    }

    public function get_title(): string
    {
        return esc_html__('Icon Box', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['icon-box', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon_selector',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'icon_class' => esc_html__('Icon Class' ,'cipher-core'),
                    'icon' => esc_html__('Icon' ,'cipher-core'),
                    'image' => esc_html__('Image' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'icon_class',
            [
                'label' => esc_html__('Icon Class' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('icon-sicon6' ,'cipher-core'),
                'description' => esc_html('Example: <i class"icomoon-phone"></i>', 'cipher-core'),
                'condition' => [
                    'icon_selector' => 'icon_class',
                ],
            ]
        );
        $this->add_control(
            '_icon',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
                'condition' => [
                    'icon_selector' => 'icon',
                ],
            ]
        );
        $this->add_control(
            '_image',
            [
                'label' => esc_html__('Choose Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_selector' => 'image',
                ],
            ]
        );
        $this->add_control(
            '_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Address' ,'cipher-core'),
            ]
        );
        $this->add_control(
            '_description',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__('Dhaka 102, utl 1216, road 45 house of street' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'ani_duration',
            [
                'label' => esc_html__('Animation Duration (MS)' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1000000,
                'step' => 100,
                'default' => 1000,
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Icon Box', '.ch-office-info-item');

        $cipher_init->typography_style($this, 'Title', '.office-info-text h2');

        $cipher_init->typography_style($this, 'Description', '.office-info-text div p');

        $cipher_init->icon_style($this, 'Icon Style', '.icon, .icon i');

    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="ch-office-info-item wow fadeInUp" data-wow-duration="<?php echo esc_attr($settings['ani_duration']); ?>ms">
            <div class="office-info-icon">
                <div class="icon">
                    <?php
                    if ($settings['icon_selector'] == 'icon_class' && !empty($settings['icon_class'])) : ?>
                        <i class="<?php echo esc_attr($settings['icon_class']); ?>"></i>
                    <?php elseif ($settings['icon_selector'] == 'icon' && !empty($settings['_icon'])) :
                        echo '<i class="' . esc_attr($settings['_icon']['library'] . ' ' . $settings['_icon']['value']) . '"></i>';
                    elseif ($settings['icon_selector'] == 'image' && !empty($settings['_image']['id'])) : ?>
                        <?php echo wp_get_attachment_image($settings['_image']['id'], 'full'); ?>
                    <?php endif;
                    ?>
                </div>
            </div>
            <div class="office-info-text">
                <?php if (!empty($settings['_title'])): ?><h2><?php echo esc_html($settings['_title']); ?></h2><?php endif; ?>
                <?php if (!empty($settings['_description'])): ?><div class="text"><?php echo wp_kses_post($settings['_description']); ?></div><?php endif; ?>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Icon_Box());
