<?php

namespace Elementor;

class Cipher_Newsletter_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-newsletter-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Newsletter V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['newsletter', 'cipher'];
    }

    protected function register_controls(): void
    {
        //text slider
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'form_title',
            [
                'label' => esc_html__('Form Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Explore the art of portfolios' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__('Form Shortcode' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('[contact-form-7 id="68abee3" title="Newsletter One"]' ,'cipher-core'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'form_background',
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .ch-newsletter-area .ch-newsletter-wrap:before',
            ]
        );
        $this->end_controls_section();


        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Body', '.ch-newsletter-area .ch-newsletter-wrap');

        $cipher_init->typography_style($this, 'Title', '.ch-newsletter-wrap h2');

        $cipher_init->typography_style($this, 'Submit Button', '.ch-newsletter-area .newsletter-form .form-field button');

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .ch-newsletter-area .newsletter-form .form-field input',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-newsletter-area .newsletter-form .form-field input::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-newsletter-area .newsletter-form .form-field input' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .ch-newsletter-area .newsletter-form .form-field input',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .ch-newsletter-area .newsletter-form .form-field input',
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <section class="ch-newsletter-area">
            <div class="container">
                <div class="ch-newsletter-wrap">
                    <?php if (!empty($settings['form_title'])): ?><h2><?php echo esc_html($settings['form_title']); ?></h2><?php endif; ?>
                    <div class="row justify-content-center">
                        <div class="col-xl-6 col-lg-8">
                            <div class="newsletter-form">
                                <?php echo do_shortcode($settings['form_shortcode']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Newsletter_V1());
