<?php

namespace Elementor;

class Cipher_Portfolio_Details extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-portfolio-details';
    }

    public function get_title(): string
    {
        return esc_html__('Portofolio Details', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['portfolio-details', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_element',
            [
                'label' => esc_html__('Select Element' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'category',
                'options' => [
                    'thumbnail' => esc_html__('Thumbnail Image' ,'cipher-core'),
                    'parallax_image' => esc_html__('Parallax Image' ,'cipher-core'),
                    'static_image' => esc_html__('Static Image' ,'cipher-core'),
                    'widget' => esc_html__('Widget' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'select_element' => ['parallax_image', 'static_image'],
                ],
            ]
        );
        $this->add_control(
            'widget_item_list',
            [
                'label' => esc_html__('Widget Item List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'condition' => [
                    'select_element' => 'widget',
                ],
                'fields' => [
                    [
                        'name' => 'widget_title',
                        'label' => esc_html__('Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Client' ,'cipher-core'),
                    ],
                    [
                        'name' => 'widget_description',
                        'label' => esc_html__('Description' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Sandi leo rakiul' ,'cipher-core'),
                    ]
                ],
                'title_field' => '{{{ widget_title }}}',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Widget Body', '.details-widget-item span');

        $cipher_init->typography_style($this, 'Widget Title', '.details-widget-item span');

        $cipher_init->typography_style($this, 'Widget Description', '.details-widget-item h4');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $select_element = $settings['select_element'] ? $settings['select_element'] : [];
        $widget_item_list = $settings['widget_item_list'] ? $settings['widget_item_list'] : [];
?>

        <?php
        if ($select_element == 'thumbnail') :
            if (has_post_thumbnail()):
        ?>
                <div class="details-img">
                    <?php the_post_thumbnail('full', array('class' => 'img-fluid')); ?>
                </div>
        <?php
            endif;
        endif;
        ?>

        <?php if ($select_element == 'parallax_image') : ?>
            <div class="simpleParallax simple-parallax-initialized">
                <?php echo wp_get_attachment_image($settings['parallax_image']['id'], 'full', false, array('class' => 'img-fluid imageParallax4')) ?>
            </div>
        <?php endif; ?>

        <?php
        if ($select_element == 'static_image') {
            echo wp_get_attachment_image($settings['static_image']['id'], 'full', false, array('class' => 'img-fluid'));
        }
        ?>

        <?php if ($select_element == 'widget'): ?>
            <div class="ch-portfolio-sidebar">
                <div class="details-widget">

                    <?php
                    if ($select_element == 'widget') :
                        foreach ($widget_item_list as $item) :

                    ?>
                            <div class="details-widget-item">
                                <?php if (!empty($item['widget_title'])): ?><span><?php echo esc_html($item['widget_title']); ?></span><?php endif; ?>
                                <?php if (!empty($item['widget_description'])): ?><h4><?php echo esc_html($item['widget_description']); ?></h4><?php endif; ?>
                            </div>
                    <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
        <?php endif; ?>


<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Portfolio_Details());
