<?php

namespace Elementor;

class Cipher_Portfolio_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-portfolio-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Portfolio V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['portfolio', 'portfolio-v1', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_portfolio',
            [
                'label' => esc_html__('Choose Portfolio' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '-1',
                'options' => cipher_get_portfolio(),
            ]
        );
        $this->add_control(
            'portfolio_image',
            [
                'label' => esc_html__('Featured Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Catgory', '.portfolio-text span, .portfolio-text span:before');

        $cipher_init->typography_style($this, 'Title', '.portfolio-text h2 a');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $portfolio_id = $settings['select_portfolio'] ? intval($settings['select_portfolio']) : '';
        $title = get_the_title($portfolio_id);
        $permalink = get_permalink($portfolio_id);

        $categories = get_the_terms($portfolio_id, 'portfolio_category');
        $category = !empty($categories) && !is_wp_error($categories) ? $categories[0]->name : '';
?>
        <div class="portfolio-item wow fadeInUp" data-wow-duration="1200ms">
            <?php if (!empty($settings['portfolio_image']['id'])): ?>
                <div class="portfolio-img">
                    <?php echo wp_get_attachment_image($settings['portfolio_image']['id'], 'full', false, array('class' => 'imageParallax4')); ?>
                </div>
            <?php endif; ?>
            <div class="portfolio-text">
                <?php if (!empty($category)): ?><span><?php echo esc_html($category) ?></span><?php endif; ?>
                <h2><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title); ?></a></h2>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Portfolio_V1());
