<?php

namespace Elementor;

class Cipher_Portfolio_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-portfolio-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Portfolio V2', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['portfolio', 'portfolio-v2', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_portfolio',
            [
                'label' => esc_html__('Choose Portfolio' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '-1',
                'options' => cipher_get_portfolio(),
            ]
        );
        $this->add_control(
            'icon_selector',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'icon_class' => esc_html__('Icon Class' ,'cipher-core'),
                    'icon' => esc_html__('Icon' ,'cipher-core'),
                    'image' => esc_html__('Image' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'icon_class',
            [
                'label' => esc_html__('Icon Class' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('icon-sicon6' ,'cipher-core'),
                'description' => esc_html('Example: <i class"icomoon-phone"></i>', 'cipher-core'),
                'condition' => [
                    'icon_selector' => 'icon_class',
                ],
            ]
        );
        $this->add_control(
            '_icon',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
                'condition' => [
                    'icon_selector' => 'icon',
                ],
            ]
        );
        $this->add_control(
			'_image',
			[
				'label' => esc_html__( 'Choose Image', 'cipher-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
                'condition' => [
                    'icon_selector' => 'image',
                ],
			]
		);
        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__('Portfolio is a collection of works that showcases an individuals' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Read More' ,'cipher-core'),
            ]
        );
        $this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);
        $this->add_control(
            'ani_duration',
            [
                'label' => esc_html__('Animation Duration (MS)' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1000000,
                'step' => 100,
                'default' => 1000,
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Item', '.ch-benefit-item');

        $cipher_init->typography_style($this, 'Title', '.benefit-text h3 a');

        $cipher_init->typography_style($this, 'Description', '.benefit-text p');

        $cipher_init->typography_style($this, 'Button', '.benefit-text a');

        $cipher_init->icon_style($this, 'Icon', '.benefit-text .icon i');

        $this->start_controls_section(
            'style_section_icon_shape',
            [
                'label' => esc_html__('Icon Shape' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_shape_bg_color',
            [
                'label' => esc_html__('Background Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-benefit-item .benefit-text .icon:before' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $portfolio_id = $settings['select_portfolio'] ? intval($settings['select_portfolio']) : '';
        $title = get_the_title($portfolio_id);
        $permalink = get_permalink($portfolio_id);
?>

        <div class="ch-benefit-item wow fadeInUp" data-wow-duration="<?php echo esc_attr($settings['ani_duration']); ?>ms">
            <div class="benefit-text">
                <div class="icon">
                    <?php
                    if ($settings['icon_selector'] == 'icon_class' && !empty($settings['icon_class'])) : ?>
                        <i class="<?php echo esc_attr($settings['icon_class']); ?>"></i>
                    <?php elseif ($settings['icon_selector'] == 'icon' && !empty($settings['_icon'])) :
                        echo '<i class="' . esc_attr($settings['_icon']['library'] . ' ' . $settings['_icon']['value']) . '"></i>';
                    elseif ($settings['icon_selector'] == 'image' && !empty($settings['_image']['id'])) : ?>
                        <?php echo wp_get_attachment_image($settings['_image']['id'], 'full'); ?>
                    <?php endif;
                    ?>
                </div>
                <?php if (!empty($title)): ?><h3><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title) ?></a></h3><?php endif; ?>
                <?php if (!empty($settings['description'])): ?><p><?php echo esc_html($settings['description']) ?></p><?php endif; ?>
                <?php if (!empty($settings['btn_title'])): ?><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($settings['btn_title']); ?></a><?php endif; ?>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Portfolio_V2());
