<?php

namespace Elementor;

class Cipher_Portfolio_V3 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-portfolio-v3';
    }

    public function get_title(): string
    {
        return esc_html__('Portfolio V3', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['portfolio', 'portfolio-v3', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Latest portfolio' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'before_title',
            [
                'label' => esc_html__('Before Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Showcase your talent' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'main_title',
            [
                'label' => esc_html__('Before Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('with' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'after_title',
            [
                'label' => esc_html__('After Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('our Latest portfolio' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => esc_html__('Select Style' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'style_one',
                'options' => [
                    'style_one' => esc_html__('Style One' ,'cipher-core'),
                    'style_two' => esc_html__('Style Two' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'portfolio_list',
            [
                'label' => esc_html__('Repeater List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'select_portfolio',
                        'label' => esc_html__('Choose Portfolio' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '-1',
                        'options' => cipher_get_portfolio(),
                    ],
                    [
                        'name' => 'number',
                        'label' => esc_html__('Number' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('01' ,'cipher-core'),
                    ],
                    [
                        'name' => 'featured_image',
                        'label' => esc_html__('Feautred Image' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'description',
                        'label' => esc_html__('Description' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'rows' => 10,
                        'default' => esc_html__('Corporate restructuring refers to the process of reorCorporate restructuring refers to the process of reorganizing a man ompanyganizing a man company' ,'cipher-core'),
                    ],
                    [
                        'name' => 'ani_duration',
                        'label' => esc_html__('Animation Duration (MS)' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::NUMBER,
                        'min' => 500,
                        'max' => 100000,
                        'step' => 100,
                        'default' => 1000,
                    ],
                ],
                'title_field' => '{{{ number }}}',
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Read More' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'sec_bg_image',
            [
                'label' => esc_html__('Background Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->end_controls_section();


        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section', '.ch-portfolio-area-s2');

        $cipher_init->typography_style($this, 'Sub Title', '.ch-top-title span');

        $cipher_init->typography_style($this, 'Title', '.ch-top-title h2');

        $cipher_init->typography_style($this, 'Main Title', '.ch-top-title h2 small');

        $cipher_init->button_style($this, 'Button', '.ch-btn-style-1');

        $cipher_init->typography_style($this, 'Portfolio Title', '.porfolio-text a');

        $cipher_init->typography_style($this, 'Portfolio Number', '.porfolio-text span i');

        $cipher_init->typography_style($this, 'Portfolio Description', '.porfolio-des p');


        $this->start_controls_section(
            'style_section_image_shape',
            [
                'label' => esc_html__('Image Shape' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_shape_bg_color',
            [
                'label' => esc_html__('Background Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-portfolio-area-s2 .porfolio-wrap .porfolio-item .porfolio-img::before' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $portfolio_list = $settings['portfolio_list'] ? $settings['portfolio_list'] : [];
        $select_style = !empty($settings['select_style']) ? $settings['select_style'] : 'style_one';

        if ($select_style == 'style_two') {
            $order_one = 'order-1';
            $order_two = 'order-2';
            $order_three = 'order-3';
        } else {
            $order_one = '';
            $order_two = '';
            $order_three = '';
        }
?>

        <section class="ch-portfolio-area-s2 ptb-120">
            <div class="container">
                <div class="ch-title-wrap">
                    <div class="row justify-content-center">
                        <div class="col-xl-5 col-lg-8 col-12">
                            <div class="ch-top-title">
                                <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                <h2 class="site-split-text ch-split-in-right"><?php echo esc_html($settings['before_title']) ?> <small><?php echo esc_html($settings['main_title']) ?></small> <?php echo esc_html($settings['after_title']) ?></h2>
                            </div>
                        </div>
                        <div class="col-xl-7 col-lg-4 col-12">
                            <div class="ch-top-btn">
                                <?php if (!empty($settings['btn_title'])): ?><a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="ch-btn-style-1 ch-btn-animated"><?php echo esc_html($settings['btn_title']); ?></a><?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="porfolio-wrap">
                    <?php
                    if (!empty($portfolio_list)) :
                        foreach ($portfolio_list as $item) :
                            $portfolio_id = !empty($item['select_portfolio']) ? $item['select_portfolio'] : '';
                            $number = !empty($item['number']) ? $item['number'] : '';
                            $description = !empty($item['description']) ? $item['description'] : '';
                            $portfolio_title = get_the_title($portfolio_id);
                            $portfolio_link = get_permalink($portfolio_id);
                            $featured_image = !empty($item['featured_image']['id']) ? $item['featured_image']['id'] : '';
                            $ani_duration = !empty($item['ani_duration']) ? $item['ani_duration'] : '1000';
                    ?>
                            <div class="porfolio-item wow fadeInUp" data-wow-duration="<?php echo esc_attr($ani_duration); ?>ms">
                                <div class="row align-items-center">

                                    <?php if (!empty($featured_image)): ?>
                                        <div class="col-lg-3 col-sm-6 col-12 <?php echo esc_attr($order_two); ?>">
                                            <div class="porfolio-img">
                                                <?php echo wp_get_attachment_image($featured_image, 'full'); ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <div class="col-lg-4 col-sm-6 col-12 <?php echo esc_attr($order_one); ?>">
                                        <div class="porfolio-text">
                                            <?php if (!empty($number)): ?><span><i><?php echo esc_html($number); ?></i></span><?php endif; ?>
                                            <a href="<?php echo esc_url($portfolio_link); ?>"><?php echo esc_html($portfolio_title); ?></a>
                                        </div>
                                    </div>

                                    <?php if (!empty($description)): ?>
                                        <div class="col-lg-5 col-sm-12 col-12 <?php echo esc_attr($order_three); ?>">
                                            <div class="porfolio-des">
                                                <p><?php echo esc_html($description); ?></p>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                    <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
            <?php if (!empty($settings['sec_bg_image']['id'])): ?>
                <div class="right-shape">
                    <?php echo wp_get_attachment_image($settings['sec_bg_image']['id'], 'full'); ?>
                </div>
            <?php endif; ?>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Portfolio_V3());
