<?php

namespace Elementor;

class Cipher_Portfolio_V4 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-portfolio-v4';
    }

    public function get_title(): string
    {
        return esc_html__('Portfolio V4', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['portfolio', 'portfolio-v4', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_portfolio',
            [
                'label' => esc_html__('Choose Portfolio' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '-1',
                'options' => cipher_get_portfolio(),
            ]
        );
        $this->add_control(
            '_image',
            [
                'label' => esc_html__('Choose Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('Category' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Development' ,'cipher-core'),
                'placeholder' => esc_html__('Type your category here' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'ani_duration',
            [
                'label' => esc_html__('Animation Duration (MS)' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1000000,
                'step' => 100,
                'default' => 1000,
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Item', '.ch-portfolio-item-wrap');

        $cipher_init->typography_style($this, 'Title', '.portfolio-heading h2 a');

        $cipher_init->typography_style($this, 'Category', '.portfolio-text span, .portfolio-text span:before');

    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $portfolio_id = $settings['select_portfolio'] ? intval($settings['select_portfolio']) : '';
        $title = get_the_title($portfolio_id);
        $permalink = get_permalink($portfolio_id);
?>

        <div class="ch-portfolio-item-wrap wow fadeInUp" data-wow-duration="<?php echo esc_attr($settings['ani_duration']); ?>ms">
            <div class="portfolio-img">
                <?php echo wp_get_attachment_image($settings['_image']['id'], 'full', false, array('class' => 'imageParallax4')); ?>
                <div class="portfolio-heading">
                    <h2><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title); ?></a></h2>
                </div>
            </div>

            <?php if(!empty($settings['category'])): ?>
            <div class="portfolio-text">
                <span><?php echo esc_html($settings['category']); ?></span>
            </div>
            <?php endif; ?>

        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Portfolio_V4());
