<?php

namespace Elementor;

class Cipher_Project_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-project-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Project V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['project', 'service-v1', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Latest service' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Showcasing excellence through portfolios' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'desc',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__('We specialize in crafting visually appealing interfaces with a focus on user-centric design. Explore my projects to see how I transform ideas into seamless, engaging experiences.' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'project_list',
            [
                'label' => esc_html__('Repeater List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'project_conter',
                        'label' => esc_html__('Service Conter' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('01' ,'cipher-core'),
                    ],
                    [
                        'name' => 'project_title',
                        'label' => esc_html__('Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Creative Design Solutions' ,'cipher-core'),
                    ],
                    [
                        'name' => 'project_image',
                        'label' => esc_html__('Choose Image' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'project_link',
                        'label' => esc_html__('Link' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'options' => ['url', 'is_external', 'nofollow'],
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                            // 'custom_attributes' => '',
                        ],
                        'label_block' => true,
                    ]

                ],
                'title_field' => '{{{ project_title }}}',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'content_section_card',
            [
                'label' => esc_html__('Card' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_card',
            [
                'label' => esc_html__('Show Card' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show' ,'cipher-core'),
                'label_off' => esc_html__('Hide' ,'cipher-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'card_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Solutions that Inspire' ,'cipher-core'),
                'condition' => [
                    'show_card' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'card_desc',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__('Improving your business online presence can be achievedfri' ,'cipher-core'),
                'condition' => [
                    'show_card' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'card_btn_text',
            [
                'label' => esc_html__('Button Text' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Read More' ,'cipher-core'),
                'condition' => [
                    'show_card' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'card_btn_link',
            [
                'label' => esc_html__('Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
                'condition' => [
                    'show_card' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'icon_selector',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'icon_class' => esc_html__('Icon Class' ,'cipher-core'),
                    'icon' => esc_html__('Icon' ,'cipher-core'),
                    'image' => esc_html__('Image' ,'cipher-core'),
                ],
                'condition' => [
                    'show_card' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'icon_class',
            [
                'label' => esc_html__('Icon Class' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('icon-design' ,'cipher-core'),
                'description' => esc_html('Example: <i class"icon-design"></i>', 'cipher-core'),
                'condition' => [
                    'icon_selector' => 'icon_class',
                    'show_card' => 'yes',
                ],
            ]
        );
        $this->add_control(
            '_icon',
            [
                'label' => esc_html__('Icon' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-circle',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                    'fa-regular' => [
                        'circle',
                        'dot-circle',
                        'square-full',
                    ],
                ],
                'condition' => [
                    'icon_selector' => 'icon',
                    'show_card' => 'yes',
                ],
            ]
        );
        $this->add_control(
            '_image',
            [
                'label' => esc_html__('Choose Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_selector' => 'image',
                    'show_card' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();


        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section Body', '.ch-service-area');

        $cipher_init->typography_style($this, 'Sub Title', '.ch-top-title span');

        $cipher_init->typography_style($this, 'Title', '.ch-top-title h2');

        $cipher_init->typography_style($this, 'Descripition', '.ch-top-btn p');

        $cipher_init->typography_style($this, 'Project Title', '.ch-service-right-wrap a .item-left h2, .ch-service-right-wrap a .item-left span');

        $cipher_init->typography_style($this, 'Project Title Hover', '.ch-service-right-wrap a .item-left h2:hover, .ch-service-area .ch-service-right-wrap .item.active h2, .ch-service-area .ch-service-right-wrap .item.active span, .ch-service-area .ch-service-right-wrap .item.active i');
        
        $cipher_init->typography_style($this, 'Card Button', '.ch-service-rtext a');

        $cipher_init->icon_style($this, 'Card Icon', '.ch-service-text-right i');

        $cipher_init->icon_style($this, 'Card Body', '.ch-service-text-right');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $project_list = $settings['project_list'] ? $settings['project_list'] : [];
?>

        <section class="ch-service-area ptb-120">
            <div class="container">
                <div class="ch-title-wrap">
                    <div class="row justify-content-center">
                        <div class="col-xl-5 col-lg-8 col-12">
                            <div class="ch-top-title">
                                <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                <?php if (!empty($settings['title'])): ?><h2 class="site-split-text ch-split-in-right"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                            </div>
                        </div>

                        <?php if (!empty($settings['desc'])): ?>
                            <div class="col-xl-6 offset-xl-1 col-lg-4 col-12">
                                <div class="ch-top-btn">
                                    <p><?php echo esc_html($settings['desc']); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="row align-items-center">
                    <div class="col-xl-6 col-lg-7 col-12">
                        <div class="ch-service-right-wrap">

                            <?php
                            if (!empty($project_list)) :
                                foreach ($project_list as $index =>  $project_item) :
                                    $active_class = ($index == 0) ? 'active' : '';
                            ?>
                                    <a href="<?php echo esc_url($project_item['project_link']['url']); ?>" class="item <?php echo esc_attr($active_class); ?>">
                                        <div class="item-left">
                                            <?php if (!empty($project_item['project_conter'])): ?><span><?php echo esc_html($project_item['project_conter']); ?></span><?php endif; ?>
                                            <h2><?php echo esc_html($project_item['project_title']); ?></h2>
                                        </div>
                                        <i class="icon-arrow"></i>
                                    </a>
                            <?php
                                endforeach;
                            endif;
                            ?>

                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-5 col-12">
                        <div class="ch-service-left-wrapper">
                            <div class="service-image-group">

                                <?php
                                if (!empty($project_list)) :
                                    foreach ($project_list as $index =>  $project_item) :
                                        $active_class = ($index == 0) ? 'active' : '';
                                        $image_id = $project_item['project_image']['id'];
                                ?>
                                        <div class="service-image <?php echo esc_attr($active_class); ?>">
                                            <?php echo wp_get_attachment_image($image_id, 'full', false, array('class' => 'imageParallax')); ?>
                                        </div>
                                <?php
                                    endforeach;
                                endif;
                                ?>

                            </div>

                            <?php if ('yes' == $settings['show_card']): ?>
                                <div class="ch-service-text-right">
                                    <?php
                                    if ($settings['icon_selector'] == 'icon_class' && !empty($settings['icon_class'])) : ?>
                                        <i class="<?php echo esc_attr($settings['icon_class']); ?>"></i>
                                    <?php elseif ($settings['icon_selector'] == 'icon' && !empty($settings['_icon'])) :
                                        echo '<i class="' . esc_attr($settings['_icon']['library'] . ' ' . $settings['_icon']['value']) . '"></i>';
                                    elseif ($settings['icon_selector'] == 'image' && !empty($settings['_image']['id'])) : ?>
                                        <?php echo wp_get_attachment_image($settings['_image']['id'], 'full'); ?>
                                    <?php endif;
                                    ?>
                                    <div class="ch-service-rtext">
                                        <?php if (!empty($settings['card_title'])): ?><h3><?php echo esc_html($settings['card_title']); ?></h3><?php endif; ?>
                                        <?php if (!empty($settings['card_desc'])): ?><p><?php echo esc_html($settings['card_desc']); ?></p><?php endif; ?>
                                        <?php if (!empty($settings['card_btn_text'])): ?><a href="<?php echo esc_url($settings['card_btn_link']['url']); ?>" class="read-more"><?php echo esc_html($settings['card_btn_text']); ?></a><?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Project_V1());
