<?php

namespace Elementor;

class Cipher_Service_Details extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-service-details';
    }

    public function get_title(): string
    {
        return esc_html__('Service Details', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['service-details', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_element',
            [
                'label' => esc_html__('Select Element' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'category',
                'options' => [
                    'thumbnail' => esc_html__('Thumbnail Image' ,'cipher-core'),
                    'category' => esc_html__('Category' ,'cipher-core'),
                    'form' => esc_html__('Form' ,'cipher-core'),
                    'details_item' => esc_html__('Details Items' ,'cipher-core'),
                    'service_item' => esc_html__('Service Items' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'category_main_title',
            [
                'label' => esc_html__('Categroy Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Category' ,'cipher-core'),
                'condition' => [
                    'select_element' => 'category',
                ]
            ]
        );
        $this->add_control(
            'category_list',
            [
                'label' => esc_html__('Cateogry List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'condition' => [
                    'select_element' => 'category',
                ],
                'fields' => [
                    [
                        'name' => 'category_title',
                        'label' => esc_html__('Select Category' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'solid',
                        'options' => ciper_service_category(),
                    ],
                ],
                'title_field' => '{{{ category_title.title }}}',
            ]
        );
        $this->add_control(
            'form_main_title',
            [
                'label' => esc_html__('Form Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Informaiton' ,'cipher-core'),
                'condition' => [
                    'select_element' => 'form',
                ]
            ]
        );
        $this->add_control(
            'service_single_form',
            [
                'label' => esc_html__('Form Shortcode' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('[contact-form-7 id="fe69f42" title="Service details form"]' ,'cipher-core'),
                'condition' => [
                    'select_element' => 'form',
                ]
            ]
        );
        $this->add_control(
            'details_item_list',
            [
                'label' => esc_html__('Details Item List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'condition' => [
                    'select_element' => 'details_item',
                ],
                'fields' => [
                    [
                        'name' => 'item_title',
                        'label' => esc_html__('Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Comprehensive' ,'cipher-core'),
                        'label_block' => true,

                    ],
                    [
                        'name' => 'item_description',
                        'label' => esc_html__('Description' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Will be distrol acte bioiiy desig is fact that' ,'cipher-core'),
                        'label_block' => true,

                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );
        $this->add_control(
            'service_item_list',
            [
                'label' => esc_html__('Service List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'condition' => [
                    'select_element' => 'service_item',
                ],
                'fields' => [
                    [
                        'name' => 'service_title',
                        'label' => esc_html__('Select Service' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'solid',
                        'options' => cipher_get_service(),
                    ],
                    [
                        'name' => 'service_description',
                        'label' => esc_html__('Description' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('A Portfolio is a collection of works that is to showcases for an individuals peoples' ,'cipher-core'),
                        'label_block' => true,

                    ],
                    [
                        'name' => 'service_btn_title',
                        'label' => esc_html__('Button Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Read More' ,'cipher-core'),
                        'label_block' => true,

                    ],
                    [
                        'name' => 'divider_1',
                        'type' => \Elementor\Controls_Manager::DIVIDER,
                    ],
                    [
                        'name' => 'ani_duration',
                        'label' => esc_html__('Animaiton Duratin (MS)' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('1000' ,'cipher-core'),
                        'label_block' => true,

                    ],
                ],
                'title_field' => '{{{ service_title.title }}}',
            ]
        );
        $this->end_controls_section();

        //category and form title style
        $this->start_controls_section(
            'category_form_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['category', 'form'],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'category_form_title_typography',
                'selector' => '{{WRAPPER}} .ch-service-sidebar .widget h3, {{WRAPPER}} .ch-service-sidebar .widget h3',
            ]
        );
        $this->add_control(
            'category_form_title_color',
            [
                'label' => esc_html__('Text Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .widget h3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .ch-service-sidebar .widget h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();


        //category item
        $this->start_controls_section(
            'category_item',
            [
                'label' => esc_html__('Catgory Item' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['category'],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'category_item_typography',
                'selector' => '{{WRAPPER}} .ch-service-sidebar .category-widget ul li a',
            ]
        );
        $this->add_control(
            'category_item_color',
            [
                'label' => esc_html__('Text Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .category-widget ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'category_item_bg_color',
            [
                'label' => esc_html__('Background Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .category-widget ul li a' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'category_item_border',
                'selector' => '{{WRAPPER}} .ch-service-sidebar .category-widget ul li a',
            ]
        );
        $this->add_control(
            'category_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'category_item_color_hover',
            [
                'label' => esc_html__('Hover Text Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .category-widget ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'category_item_bg_color_hover',
            [
                'label' => esc_html__('Hover Background Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .category-widget ul li a:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        //form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'form',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .ch-service-sidebar .info-widget input, .ch-service-sidebar .info-widget select, .ch-service-sidebar .info-widget textarea',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .info-widget select, .ch-service-sidebar .info-widget input::placeholder, .ch-service-sidebar .info-widget select::placeholder, .ch-service-sidebar .info-widget textarea::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .info-widget input, .ch-service-sidebar .info-widget select, .ch-service-sidebar .info-widget textarea' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .ch-service-sidebar .info-widget input, .ch-service-sidebar .info-widget select, .ch-service-sidebar .info-widget textarea',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .ch-service-sidebar .info-widget input, .ch-service-sidebar .info-widget select, .ch-service-sidebar .info-widget textarea',
            ]
        );
        $this->end_controls_section();

        //form button
        $this->start_controls_section(
            'form_button_style',
            [
                'label' => esc_html__('Form Button' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['form'],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'form_button_style_typography',
                'selector' => '{{WRAPPER}} .ch-service-sidebar .info-widget button',
            ]
        );
        $this->add_control(
            'form_button_style_color',
            [
                'label' => esc_html__('Text Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .info-widget button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_button_style_bg_color',
            [
                'label' => esc_html__('Background Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .info-widget button' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_button_style_border',
                'selector' => '{{WRAPPER}} .ch-service-sidebar .info-widget button',
            ]
        );
        $this->add_control(
            'form_btn_hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'form_button_style_color_hover',
            [
                'label' => esc_html__('Hover Text Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .info-widget button:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_button_style_bg_color_hover',
            [
                'label' => esc_html__('Hover Background Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-service-sidebar .info-widget button:hover' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        //details item title
        $this->start_controls_section(
            'details_item_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['details_item'],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'details_item_title_typography',
                'selector' => '{{WRAPPER}} .ch-details-items h3',
            ]
        );
        $this->add_control(
            'details_item_title_color',
            [
                'label' => esc_html__('Text Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-details-items h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        //details item description
        $this->start_controls_section(
            'details_item_description',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['details_item'],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'details_item_description_typography',
                'selector' => '{{WRAPPER}} .ch-details-items p',
            ]
        );
        $this->add_control(
            'details_item_description_color',
            [
                'label' => esc_html__('Text Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-details-items p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        //details item icon
        $this->start_controls_section(
            'details_item_icon',
            [
                'label' => esc_html__('icon' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['details_item'],
                ],
            ]
        );
        $this->add_control(
            'details_item_icon_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-details-items h3 i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'details_item_icon_bg_color',
            [
                'label' => esc_html__('Background' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-details-items h3 i' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        //service item
        $this->start_controls_section(
            'service_item',
            [
                'label' => esc_html__('Item' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['service_item'],
                ],
            ]
        );
        $this->add_control(
            'service_item_',
            [
                'label' => esc_html__('Background' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-single-service-area .service-item' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'service_item_border',
				'selector' => '{{WRAPPER}} .ch-single-service-area .service-item',
			]
		);
        $this->end_controls_section();


        //service item title
        $this->start_controls_section(
            'service_item_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['service_item'],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'service_item_title_typography',
                'selector' => '{{WRAPPER}} .ch-single-service-area .service-item .service-text h3 a',
            ]
        );
        $this->add_control(
            'service_item_title_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-single-service-area .service-item .service-text h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();


        //service item description
        $this->start_controls_section(
            'service_item_description',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['service_item'],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'service_item_description_typography',
                'selector' => '{{WRAPPER}} .ch-single-service-area .service-item .service-text p',
            ]
        );
        $this->add_control(
            'service_item_description_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-single-service-area .service-item .service-text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        //service item button
        $this->start_controls_section(
            'service_item_button',
            [
                'label' => esc_html__('Button' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => ['service_item'],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'service_item_button_typography',
                'selector' => '{{WRAPPER}} .ch-single-service-area .service-item .service-text a.read-more',
            ]
        );
        $this->add_control(
            'service_item_button_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-single-service-area .service-item .service-text a.read-more' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'service_item_button_color_hover',
            [
                'label' => esc_html__('Hover Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-single-service-area .service-item .service-text a.read-more:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $category_list = $settings['category_list'] ? $settings['category_list'] : [];
        $select_element = $settings['select_element'] ? $settings['select_element'] : 'category';
        $details_item_list = $settings['details_item_list'] ? $settings['details_item_list'] : [];
        $service_item_list = $settings['service_item_list'] ? $settings['service_item_list'] : [];
?>

        <?php
        if ($select_element == 'thumbnail') :
            if (has_post_thumbnail()):
        ?>
                <div class="details-img">
                    <?php the_post_thumbnail('full', array('class' => 'img-fluid')); ?>
                </div>
        <?php
            endif;
        endif;
        ?>

        <?php if ($select_element == 'category'): ?>
            <div class="ch-service-sidebar">
                <div class="widget category-widget">
                    <?php if (!empty($settings['category_main_title'])): ?><h3><?php echo esc_html($settings['category_main_title']); ?></h3><?php endif; ?>
                    <ul>
                        <?php
                        if (!empty($category_list)) :
                            foreach ($category_list as $item) :
                                $term_id = !empty($item['category_title']) ? intval($item['category_title']) : 0;

                                if (!$term_id) {
                                    continue;
                                }

                                $term = get_term($term_id, 'service_category');
                                if (is_wp_error($term) || empty($term)) {
                                    continue;
                                }

                                $term_name = $term->name;
                                $term_link = get_term_link($term);
                        ?>
                                <li><a href="<?php echo esc_url($term_link); ?>"><?php echo esc_html($term_name); ?></a></li>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($select_element == 'form'): ?>
            <div class="ch-service-sidebar">
                <div class="widget info-widget">
                    <?php if (!empty($settings['form_main_title'])): ?><h3><?php echo esc_html($settings['form_main_title']); ?></h3><?php endif; ?>
                    <div>
                        <?php echo do_shortcode($settings['service_single_form']); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>


        <?php if ($select_element == 'details_item'): ?>
            <div class="ch-details-items">
                <div class="row">
                    <?php
                    if (!empty($details_item_list)) :
                        foreach ($details_item_list as $item) :
                    ?>
                            <div class="col-lg-3 col-md-6 col-12">
                                <?php if (!empty($item['item_title'])): ?><h3><i class="ti-check"></i> <?php echo esc_html($item['item_title']); ?></h3><?php endif; ?>
                                <?php if (!empty($item['item_description'])): ?><p><?php echo esc_html($item['item_description']); ?></p><?php endif; ?>
                            </div>
                    <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if ($select_element == 'service_item'): ?>
            <div class="ch-single-service-area">
                <div class="service-wrap">
                    <div class="row">

                        <?php
                        if (!empty($service_item_list)):
                            foreach ($service_item_list as $item):
                                $id = $item['service_title'] ? intval($item['service_title']) : 0;
                                $title = get_the_title($id);
                                $permalink = get_permalink($id);
                                $description = $item['service_description'];
                                $btn_title = $item['service_btn_title'];
                        ?>

                                <div class="col col-lg-6 col-md-6 col-12">
                                    <div class="service-item wow fadeInUp" data-wow-duration="<?php echo esc_attr($item['ani_duration']); ?>ms">
                                        <div class="service-text">
                                            <h3><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title); ?></a></h3>
                                            <?php if (!empty($description)): ?><p><?php echo esc_html($description); ?></p><?php endif; ?>
                                            <?php if (!empty($btn_title)): ?><a href="<?php echo esc_url($permalink); ?>" class="read-more"><?php echo esc_html($btn_title); ?></a><?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                        <?php

                            endforeach;
                        endif;
                        ?>

                    </div>
                </div>
            </div>
        <?php endif; ?>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Service_Details());
