<?php

namespace Elementor;

class Cipher_Service_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-service-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Service V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['service', 'service-v1', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => esc_html__('Select Style' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'one',
                'options' => [
                    'one' => esc_html__('Style One' ,'cipher-core'),
                    'two' => esc_html__('Style Two' ,'cipher-core'),
                ],
            ]
        );
        $this->add_control(
            'service_list',
            [
                'label' => esc_html__('Repeater List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'select_icon',
                        'label' => esc_html__('Select Style' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'one',
                        'options' => [
                            'icon_class' => esc_html__('Icon Class' ,'cipher-core'),
                            'icon' => esc_html__('Icon' ,'cipher-core'),
                            'image' => esc_html__('Image' ,'cipher-core'),
                        ],
                    ],
                    [
                        'name' => 'icon',
                        'label' => esc_html__('Icon Class', 'cipher-core'),
                        'type'  => Controls_Manager::TEXT,
                        'default' => 'icomoon-phone',
                        'description' => esc_html('Example: <i class"icomoon-phone"></i>', 'cipher-core'),
                        'condition' => [
                            'select_icon' => 'icon_class',
                        ],
                    ],
                    [
                        'name' => 'icon_new',
                        'label' => esc_html__('Icon' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-circle',
                            'library' => 'fa-solid',
                        ],
                        'recommended' => [
                            'fa-solid' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                            'fa-regular' => [
                                'circle',
                                'dot-circle',
                                'square-full',
                            ],
                        ],
                        'condition' => [
                            'select_icon' => 'icon',
                        ],
                    ],
                    [
                        'name' => '_image',
                        'label' => esc_html__('Choose Image' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                        'condition' => [
                            'select_icon' => 'image',
                        ],
                    ],
                    [
                        'name' => 'choose_service',
                        'label' => esc_html__('Choose Service' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '-1',
                        'options' => cipher_get_service(),
                    ],
                    [
                        'name' => 'service_description',
                        'label' => esc_html__('Description' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'rows' => 10,
                        'default' => esc_html__('Purus velit aenean quis habitant eros the a bibendum aenean quis habit aeros who ath bibendumPurus velit aenean' ,'cipher-core'),
                    ],
                    [
                        'name' => 'btn_text',
                        'label' => esc_html__('Button Text' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Read More' ,'cipher-core'),
                    ]
                ],
                'title_field' => '{{{ choose_service.title }}}',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Service Item', '.service-item');

        $cipher_init->typography_style($this, 'Title', '.service-text h3 a');

        $cipher_init->typography_style($this, 'Description', '.service-text p');

        $cipher_init->typography_style($this, 'Button', '.read-more');

        $cipher_init->icon_style($this, 'Icon', '.icon i');


        $this->start_controls_section(
            'shape_section',
            [
                'label' => esc_html__('Shape' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'shape_bg_color',
            [
                'label' => esc_html__('Background' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-item .service-text .icon:before, .service-item-s2 .service-text .icon:before' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'left',
            [
                'label' => esc_html__('Left' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-area .service-item .service-text .icon:before' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'top',
            [
                'label' => esc_html__('Top' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-area .service-item .service-text .icon:before' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $service_list = $settings['service_list'] ? $settings['service_list'] : [];
        $select_style = $settings['select_style'];

        $select_style_class = 'one' === $select_style ? 'service-area' : 'service-area-s2';
?>
        <section class="<?php echo esc_attr($select_style_class); ?> ptb-120">
            <div class="container">
                <div class="service-wrap">
                    <div class="row">

                        <?php
                        if (!empty($service_list)) {
                            foreach ($service_list as $index =>  $service_item) {
                                $service_id = $service_item['choose_service'] ? intval($service_item['choose_service']) : '';
                                $title = get_the_title($service_id);
                                $link = get_permalink($service_id);
                                $active_class = ($index == 1) ? 'active' : '';

                        ?>
                                <div class="col col-lg-4 col-md-6 col-12">
                                    <div class="service-item wow fadeInUp <?php echo esc_attr($active_class); ?>" data-wow-duration="1000ms">
                                        <div class="service-text">

                                            <div class="icon">
                                                <?php
                                                if ($service_item['select_icon'] === 'icon') {
                                                    echo '<i class="' . esc_attr($service_item['icon_new']['library'] . ' ' . esc_attr($service_item['icon_new']['value'])) . '"></i>';
                                                } elseif ($service_item['select_icon'] === '_image' && !empty($service_item['_image']['url'])) {
                                                    echo '<img src="' . esc_url($service_item['_image']['url']) . '" alt="' . esc_attr($title) . '">';
                                                } elseif ($service_item['select_icon'] === 'icon_class') {
                                                    echo '<i class="' . esc_attr($service_item['icon']) . '"></i>';
                                                }
                                                ?>
                                            </div>

                                            <?php if (!empty($title)): ?><h3><a href="<?php echo esc_url($link); ?>"><?php echo esc_html($title); ?></a></h3><?php endif; ?>
                                            <?php
                                            if (!empty($service_item['service_description'])) {
                                                echo '<p>' . esc_html($service_item['service_description']) . '</p>';
                                            }
                                            ?>
                                            <?php if (!empty($service_item['btn_text'])): ?><a href="<?php echo esc_url($link); ?>" class="read-more"><?php echo esc_html($service_item['btn_text']); ?></a><?php endif ?>
                                        </div>
                                    </div>
                                </div>
                        <?php
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
        </section>

<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Service_V1());
