<?php

namespace Elementor;

class Cipher_Service_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-service-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Service V2', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['service', 'service-v2', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Latest service' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Showcasing excellence through portfolios' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('Button Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('See More' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('Button Link' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'service_list',
            [
                'label' => esc_html__('Repeater List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'service_conter',
                        'label' => esc_html__('Service Conter' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('01' ,'cipher-core'),
                    ],
                    [
                        'name' => 'choose_service',
                        'label' => esc_html__('Choose Service' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => '-1',
                        'options' => cipher_get_service(),
                    ],
                    [
                        'name' => 'service_image',
                        'label' => esc_html__('Choose Image' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],

                ],
                'title_field' => '{{{ choose_service.title }}}',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Section Body', '.ch-service-area');

        $cipher_init->typography_style($this, 'Sub Title', '.ch-top-title span');

        $cipher_init->typography_style($this, 'Title', '.ch-top-title h2');

        $cipher_init->button_style($this, 'Button', '.ch-btn-style-1');

        $cipher_init->typography_style($this, 'Service Title', '.ch-service-right-wrap a .item-left h2, .ch-service-right-wrap a .item-left span');

        $cipher_init->typography_style($this, 'Service Title Hover', '.ch-service-right-wrap a .item-left h2:hover, .ch-service-area .ch-service-right-wrap .item.active h2, .ch-service-area .ch-service-right-wrap .item.active span, .ch-service-area .ch-service-right-wrap .item.active i');

    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $service_list = $settings['service_list'] ? $settings['service_list'] : [];
?>
        <section class="ch-service-area ptb-120">
            <div class="container">
                <div class="ch-title-wrap">
                    <div class="row justify-content-center">
                        <div class="col-xl-5 col-lg-8 col-12">
                            <div class="ch-top-title">
                                <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']); ?></span><?php endif; ?>
                                <?php if (!empty($settings['title'])): ?><h2 class="site-split-text ch-split-in-right"><?php echo esc_html($settings['title']); ?></h2><?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-7 col-lg-4 col-12">
                            <?php if (!empty($settings['btn_title'])): ?>
                                <div class="ch-top-btn">
                                    <a href="<?php echo esc_url($settings['btn_link']['url']); ?>" class="ch-btn-style-1 ch-btn-animated"><?php echo esc_html($settings['btn_title']); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row align-items-center">
                    <div class="col-xl-5 col-lg-5 col-12">
                        <div class="ch-service-left-wrapper">
                            <div class="service-image-group">
                                <?php
                                if (!empty($service_list)) :
                                    foreach ($service_list as $index =>  $service_item) :
                                        $active_class = ($index == 0) ? 'active' : '';
                                        $image_id = $service_item['service_image']['id'];
                                ?>
                                        <div class="service-image <?php echo esc_attr($active_class); ?>">
                                            <?php echo wp_get_attachment_image($image_id, 'full', false, array('class' => 'imageParallax')); ?>
                                        </div>
                                <?php
                                    endforeach;
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-7 col-lg-7 col-12">
                        <div class="ch-service-right-wrap">

                            <?php
                            if (!empty($service_list)) :
                                foreach ($service_list as $index =>  $service_item) :
                                    $service_id = $service_item['choose_service'] ? intval($service_item['choose_service']) : '';
                                    $title = get_the_title($service_id);
                                    $link = get_permalink($service_id);
                                    $active_class = ($index == 0) ? 'active' : '';
                            ?>
                                    <a href="<?php echo esc_url($link); ?>" class="item <?php echo esc_attr($active_class); ?>">
                                        <div class="item-left">
                                            <?php if (!empty($service_item['service_conter'])): ?><span><?php echo esc_html($service_item['service_conter']); ?></span><?php endif; ?>
                                            <h2><?php echo esc_html($title); ?></h2>
                                        </div>
                                        <i class="icon-arrow"></i>
                                    </a>
                            <?php
                                endforeach;
                            endif;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Service_V2());
