<?php

namespace Elementor;

class Cipher_Team_Details extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-team-details';
    }

    public function get_title(): string
    {
        return esc_html__('Team Details', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['team-details', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_element',
            [
                'label' => esc_html__('Select Element' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'profile',
                'options' => [
                    'profile' => esc_html__('Profile' ,'cipher-core'),
                    'contact_info' => esc_html__('Contact Info' ,'cipher-core'),
                    'personal_info' => esc_html__('Personal Info' ,'cipher-core'),
                    'form' => esc_html__('Form' ,'cipher-core'),
                ],
            ]
        );

        //team details profile content controls
        $this->add_control(
            'team_details_profession',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Founder' ,'cipher-core'),
                'condition' => [
                    'select_element' => 'profile',
                ],
            ]
        );

        //contact info content controls
        $this->add_control(
            'contact_info_title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('Contact info' ,'cipher-core'),
                'condition' => [
                    'select_element' => 'contact_info',
                ],
            ]
        );
        $this->add_control(
            'contact_info_list',
            [
                'label' => esc_html__('Contact Info List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'condition' => [
                    'select_element' => 'contact_info',
                ],
                'fields' => [
                    [
                        'name' => 'contact_title',
                        'label' => esc_html__('Title' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('Phone:' ,'cipher-core'),
                    ],
                    [
                        'name' => 'contact_description',
                        'label' => esc_html__('Description' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => esc_html__('+1234 - 0006514654' ,'cipher-core'),
                    ]
                ],
                'title_field' => '{{{ contact_title }}}',
            ]
        );

        //form content controls
        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__('Shortcode' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => esc_html__('[contact-form-7 id="cd38226" title="Team details form"]' ,'cipher-core'),
                'condition' => [
                    'select_element' => 'form',
                ],
            ]
        );

        //personal info has no content controls
        /*=============================================
        =            INNER (SOCIAL) REPEATER          =
        =============================================*/
        $social_repeater = new Repeater();

        $social_repeater->add_control(
            'social_icon',
            [
                'label' => esc_html__('Icon', 'cipher-core'),
                'type'  => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $social_repeater->add_control(
            'social_link',
            [
                'label' => esc_html__('Link', 'cipher-core'),
                'type'  => Controls_Manager::URL,
                'default' => [
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                ],
            ]
        );

        /*=============================================
        =            OUTER (PERSONAL) REPEATER        =
        =============================================*/
        $personal_repeater = new Repeater();

        $personal_repeater->add_control(
            'personal_title',
            [
                'label'       => esc_html__('Title', 'cipher-core'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__('Position', 'cipher-core'),
            ]
        );

        $personal_repeater->add_control(
            'personal_desc',
            [
                'label'       => esc_html__('Description', 'cipher-core'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => esc_html__('Team Leader', 'cipher-core'),
            ]
        );

        $personal_repeater->add_control(
            'show_icon',
            [
                'label'        => esc_html__('Show Social Icons', 'cipher-core'),
                'type'         => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $personal_repeater->add_control(
            'social_icons',
            [
                'label'     => esc_html__('Social Icons', 'cipher-core'),
                'type'      => Controls_Manager::REPEATER,
                'fields'    => $social_repeater->get_controls(),
                'condition' => [
                    'show_icon' => 'yes',
                ],
            ]
        );

        /*=============================================
        =            MAIN CONTROL                     =
        =============================================*/
        $this->add_control(
            'personal_info_list',
            [
                'label'     => esc_html__('Personal Info List', 'cipher-core'),
                'type'      => Controls_Manager::REPEATER,
                'fields'    => $personal_repeater->get_controls(),
                'condition' => [
                    'select_element' => 'personal_info',
                ],
                'title_field' => '{{{ personal_title }}}',
            ]
        );
        $this->end_controls_section();

        // profile body
        $this->start_controls_section(
            'profile_body_style_section',
            [
                'label' => esc_html__('Style' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'profile',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'profile_body_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .team-single-sidebar .team-widget',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'profile_body_border',
                'selector' => '{{WRAPPER}} .team-single-sidebar .team-widget',
            ]
        );
        $this->end_controls_section();

        //profile title style controls
        $this->start_controls_section(
            'profile_title_style_section',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'profile',
                ],
            ]
        );
        $this->add_control(
            'profile_title_text_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-single-sidebar .team-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'profile_title_content_typography',
                'selector' => '{{WRAPPER}} .team-single-sidebar .team-title h2',
            ]
        );
        $this->end_controls_section();

        //profile profession style controls
        $this->start_controls_section(
            'profile_profession_style_section',
            [
                'label' => esc_html__('Profession' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'profile',
                ],
            ]
        );
        $this->add_control(
            'profile_profession_text_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-single-sidebar .team-title span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'profile_profession_content_typography',
                'selector' => '{{WRAPPER}} .team-single-sidebar .team-title span',
            ]
        );
        $this->end_controls_section();

        // contact body
        $this->start_controls_section(
            'contact_body_style_section',
            [
                'label' => esc_html__('Contact' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'contact_info',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'contact_body_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .team-single-sidebar .contact-widget',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'contact_body_border',
                'selector' => '{{WRAPPER}} .team-single-sidebar .contact-widget',
            ]
        );
        $this->end_controls_section();

        //contact title style controls
        $this->start_controls_section(
            'contact_title_style_section',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'contact_info',
                ],
            ]
        );
        $this->add_control(
            'contact_title_text_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-single-sidebar .widget h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contact_title_content_typography',
                'selector' => '{{WRAPPER}} .team-single-sidebar .widget h3',
            ]
        );
        $this->end_controls_section();

        //contact profession style controls
        $this->start_controls_section(
            'contact_profession_style_section',
            [
                'label' => esc_html__('Description' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'contact_info',
                ],
            ]
        );
        $this->add_control(
            'contact_profession_text_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-single-sidebar .widget ul li' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .team-single-sidebar .widget ul li span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contact_profession_content_typography',
                'selector' => '{{WRAPPER}} .team-single-sidebar .widget ul li, {{WRAPPER}} .team-single-sidebar .widget ul li span',
            ]
        );
        $this->end_controls_section();

        // personal body style controls
        $this->start_controls_section(
            'personal_body_style_section',
            [
                'label' => esc_html__('Personal Body' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'personal_info',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'personal_body_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .ch-team-info-table',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'personal_body_border',
                'selector' => '{{WRAPPER}} .ch-team-info-table td',
            ]
        );
        $this->end_controls_section();

        //personal title style controls
        $this->start_controls_section(
            'personal_title_style_section',
            [
                'label' => esc_html__('Personal Title' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'personal_info',
                ],
            ]
        );
        $this->add_control(
            'personal_title_text_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-team-info-table .table tr > td:first-child' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'personal_title_content_typography',
                'selector' => '{{WRAPPER}} .ch-team-info-table .table tr > td:first-child',
            ]
        );
        $this->end_controls_section();

        //personal description style controls
        $this->start_controls_section(
            'personal_description_style_section',
            [
                'label' => esc_html__('Personal Description' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'personal_info',
                ],
            ]
        );
        $this->add_control(
            'personal_description_text_color',
            [
                'label' => esc_html__('Color' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-team-info-table td' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .team-social li a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'personal_description_content_typography',
                'selector' => '{{WRAPPER}} .ch-team-info-table td',
            ]
        );
        $this->end_controls_section();

        // form style controls
        $this->start_controls_section(
            'form_style_option',
            [
                'label' => esc_html__('Form', 'aivora-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'form',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'field_typography',
                'selector' => '{{WRAPPER}} .ch-team-single-contact form input, .ch-team-single-contact form textarea',
            ]
        );
        $this->add_control(
            'form_bg_color',
            [
                'label' => esc_html__('Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-team-single-contact form input::placeholder, .ch-team-single-contact form textarea::placeholder, .ch-team-single-contact form select::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_bg-c',
            [
                'label' => esc_html__('Background Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-team-single-contact form input, .ch-team-single-contact form textarea' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_box_shadow',
                'selector' => '{{WRAPPER}} .ch-team-single-contact form input, .ch-team-single-contact form textarea',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'selector' => '{{WRAPPER}} .ch-team-single-contact form input, .ch-team-single-contact form textarea',
            ]
        );
        $this->end_controls_section();

        //from button
        $this->start_controls_section(
            'form_button_style_section',
            [
                'label' => esc_html__('Button' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'select_element' => 'form',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'form_btn_typography',
                'selector' => '{{WRAPPER}} .ch-btn-style-3',
            ]
        );
        $this->add_control(
            'form_btn_color',
            [
                'label' => esc_html__('Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-btn-style-3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_btn_bg_color',
            [
                'label' => esc_html__('Background Color', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-btn-style-3' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_btn_color_hover',
            [
                'label' => esc_html__('Color Hover', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-btn-style-3:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'form_btn_bg_color_hover',
            [
                'label' => esc_html__('Background Hover', 'cipher-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ch-btn-style-3:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $select_element = $settings['select_element'] ? $settings['select_element'] : [];
        $contact_info_list = $settings['contact_info_list'] ? $settings['contact_info_list'] : [];
?>

        <?php
        if ($select_element == 'profile') :
        ?>
            <div class="team-single-sidebar">
                <div class="widget team-widget">

                    <?php if (has_post_thumbnail()): ?>
                        <div class="img-holder">
                            <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                        </div>
                    <?php endif; ?>

                    <div class="team-title">
                        <h2><?php echo esc_html(get_the_title()); ?></h2>
                        <?php if (!empty($settings['team_details_profession'])): ?><span><?php echo esc_html($settings['team_details_profession']); ?></span><?php endif; ?>
                    </div>

                </div>
            </div>
        <?php
        endif;
        ?>

        <?php if ($select_element == 'contact_info') : ?>
            <div class="team-single-sidebar">
                <div class="widget contact-widget">
                    <?php if (!empty($settings['contact_info_title'])): ?><h3><?php echo esc_html($settings['contact_info_title']); ?></h3><?php endif; ?>
                    <ul>
                        <?php
                        if (!empty($contact_info_list)) :
                            foreach ($contact_info_list as $item) :
                        ?>
                                <li>
                                    <?php if (!empty($item['contact_title'])): ?><span><?php echo esc_html($item['contact_title']); ?></span><?php endif; ?>
                                    <?php echo esc_html($item['contact_description']); ?>
                                </li>
                        <?php
                            endforeach;
                        endif;
                        ?>

                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php
        if ($select_element == 'form') {
        ?>
            <div class="ch-team-single-contact">
                <div class="contact-form">
                    <div class="row clearfix">
                        <?php echo do_shortcode($settings['form_shortcode']); ?>
                    </div>
                </div>
            </div>
        <?php
        }
        ?>

        <?php if ($select_element == 'personal_info'): ?>

            <div class="ch-team-info-table">
                <table class="table">
                    <colgroup>
                        <col class="first-col">
                        <col class="sec-col">
                    </colgroup>
                    <?php foreach ($settings['personal_info_list'] as $item) : ?>
                        <tr>
                            <td class="title">
                                <?php echo esc_html($item['personal_title']); ?>
                            </td>

                            <td class="desc">
                                <?php echo esc_html($item['personal_desc']); ?>

                                <?php if ($item['show_icon'] === 'yes' && ! empty($item['social_icons'])) : ?>
                                    <ul class="team-social">
                                        <?php foreach ($item['social_icons'] as $icon) : ?>
                                            <li>
                                                <a href="<?php echo esc_url($icon['social_link']['url']); ?>"
                                                    <?php echo $icon['social_link']['is_external'] ? 'target="_blank"' : ''; ?>
                                                    <?php echo $icon['social_link']['nofollow'] ? 'rel="nofollow"' : ''; ?>>

                                                    <i class="<?php echo esc_attr($icon['social_icon']['library'] . ' ' . $icon['social_icon']['value']); ?>"></i>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        <?php endif; ?>


<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Team_Details());
