<?php

namespace Elementor;

class Cipher_Team_V1 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-team-v1';
    }

    public function get_title(): string
    {
        return esc_html__('Team V1', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['team', 'team-v1', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_team',
            [
                'label' => esc_html__('Select Team Member' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => cipher_get_team(),
            ]
        );
        $this->add_control(
            'profession',
            [
                'label' => esc_html__('Profession' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Founder' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'ani_duration',
            [
                'label' => esc_html__('Animation Duration (MS)' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 500,
                'max' => 1000000,
                'step' => 100,
                'default' => 1000,
            ]
        );

        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->section_style($this, 'Team Item', '.ch-team-item');

        $cipher_init->section_style($this, 'Team Item BG', '.ch-team-item:before');

        $cipher_init->typography_style($this, 'Title', '.team-text h3 a');

        $cipher_init->typography_style($this, 'Profession', '.team-text span');

    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $select_team  = $settings['select_team'] ? intval($settings['select_team']) : 0;
        $title = get_the_title($select_team);
        $permalink = get_permalink($select_team);
        $attachment_id = get_post_thumbnail_id($select_team);
        $featured_img = $attachment_id ? wp_get_attachment_image($attachment_id, 'full') : '';
?>
        <div class="ch-team-item wow fadeInUp" data-wow-duration="<?php echo esc_attr($settings['ani_duration']); ?>ms">

            <?php if (!empty($featured_img)): ?>
                <div class="team-img">
                    <?php echo $featured_img; ?>
                </div>
            <?php endif; ?>

            <div class="team-text">
                <h3><a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title); ?></a></h3>
                <?php if (!empty($settings['profession'])): ?><span><?php echo esc_html($settings['profession']); ?></span><?php endif; ?>
            </div>
        </div>

<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Team_V1());
