<?php

namespace Elementor;

class Cipher_Testimonial_V2 extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-testimonial-v2';
    }

    public function get_title(): string
    {
        return esc_html__('Testimonial V2', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['testimonial', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('Sub Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('CLIENTS REVIEWS' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('your talent with our Latest portfolio' ,'cipher-core'),
            ]
        );
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__('Choose Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'shape_image',
            [
                'label' => esc_html__('Shape Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'testimonal_list',
            [
                'label' => esc_html__('Testimonial List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'image',
                        'label' => esc_html__('Choose Image' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'name',
                        'label' => esc_html__('Name' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Darlene Robertson' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'profession',
                        'label' => esc_html__('Profession' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('Software Engineer' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'description',
                        'label' => esc_html__('Description' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__('Software Engineer' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'rating',
                        'label' => esc_html__('Rating' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'default' => 'five',
                        'options' => [
                            'one' => esc_html__('Double' ,'cipher-core'),
                            'two' => esc_html__('Two' ,'cipher-core'),
                            'one' => esc_html__('Three' ,'cipher-core'),
                            'four' => esc_html__('Four' ,'cipher-core'),
                            'five' => esc_html__('Five' ,'cipher-core'),
                        ],
                    ]
                ],
                'title_field' => '{{{ name }}}',
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Sub Title', '.ch-top-title-s3 span');

        $cipher_init->typography_style($this, 'Title', '.ch-top-title-s3 h2');

        $cipher_init->typography_style($this, 'Name', '.testimonial-text-btm h3');

        $cipher_init->typography_style($this, 'Profession', '.testimonial-text-btm span');

        $cipher_init->typography_style($this, 'Description', '.testimonial-text p');

        $cipher_init->section_style($this, 'Slider Body', '.testimonial-section-s2 .testimonial-item');

        $cipher_init->icon_style($this, 'Icon', '.slider-arrow-wrapper div i');

        $cipher_init->icon_style($this, 'Icon Hover', '.slider-arrow-wrapper div i:hover');

        $cipher_init->icon_style($this, 'Ratings', '.testimonial-text ul li i');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <section class="testimonial-section-s2 ptb-120">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="testimonial-left">
                            <div class="ch-top-title-s3">
                                <?php if (!empty($settings['sub_title'])): ?><span><?php echo esc_html($settings['sub_title']) ?></span><?php endif; ?>
                                <?php if (!empty($settings['title'])): ?><h2 class="site-split-text ch-split-in-right"><?php echo esc_html($settings['title']) ?></h2><?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <div class="slider-arrow d-none d-lg-flex">
                            <div class="slider-arrow-wrapper">
                                <div class="swiper-button-prev"><i class="fa-regular fa-arrow-right-long"></i></div>
                                <div class="swiper-button-next"><i class="fa-regular fa-arrow-left-long"></i></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <div class="swiper testimoial-item-2 overflow-hidden">
                            <div class="swiper-wrapper testimonial-items testimonial-active owl-carousel">
                                <?php
                                if ($settings['testimonal_list']) :
                                    foreach ($settings['testimonal_list'] as $item) :
                                ?>
                                        <div class="swiper-slide testimonial-item">
                                            <div class="testimonial-text">

                                                <?php if (!empty($item['rating'])): ?>
                                                    <ul>
                                                        <?php
                                                        if ($item['rating'] == 'five') {
                                                            $stars = 5;
                                                        } elseif ($item['rating'] == 'four') {
                                                            $stars = 4;
                                                        } elseif ($item['rating'] == 'three') {
                                                            $stars = 3;
                                                        } elseif ($item['rating'] == 'two') {
                                                            $stars = 2;
                                                        } else {
                                                            $stars = 1;
                                                        }
                                                        for ($i = 1; $i <= $stars; $i++) {
                                                            echo '<li><i class="ti-star"></i></li>';
                                                        }
                                                        ?>
                                                    </ul>
                                                <?php endif; ?>

                                                <?php if (!empty($item['description'])): ?><p><?php echo esc_html($item['description']); ?></p><?php endif; ?>
                                                <div class="testimonial-info">
                                                    <div class="testimonial-avatar">
                                                        <?php echo wp_get_attachment_image($item['image']['id'], 'full'); ?>
                                                    </div>
                                                    <div class="testimonial-text-btm">
                                                        <?php if (!empty($item['name'])): ?><h3><?php echo esc_html($item['name']); ?></h3><?php endif; ?>
                                                        <?php if (!empty($item['profession'])): ?><span><?php echo esc_html($item['profession']); ?></span><?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                <?php
                                    endforeach;
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                    <?php if (!empty($settings['bg_image']['id'])): ?>
                        <div class="col-lg-5">
                            <div class="testimonial-right-img">
                                <?php echo wp_get_attachment_image($settings['bg_image']['id'], 'full'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <?php if (!empty($settings['shape_image']['id'])): ?>
                <div class="right-shape">
                    <?php echo wp_get_attachment_image($settings['shape_image']['id'], 'full'); ?>
                </div>
            <?php endif; ?>

        </section>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Testimonial_V2());
