<?php

namespace Elementor;

class Cipher_Text_Slider extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-text-slider';
    }

    public function get_title(): string
    {
        return esc_html__('Text Slider', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['text-slider', 'marquee', 'cipher'];
    }

    protected function register_controls(): void
    {
        //text slider
        $this->start_controls_section(
            'content_section_text_slider',
            [
                'label' => esc_html__('Text Slider' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'list',
            [
                'label' => esc_html__('Text List' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'list_title_one',
                        'label' => esc_html__('Title One' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('WEB DESIGNER' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'list_title_two',
                        'label' => esc_html__('Title Two' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('WEB DESIGNER' ,'cipher-core'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'icon_class',
                        'label' => esc_html__('Icon Class' ,'cipher-core'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('icon-sicon5' ,'cipher-core'),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ list_title_one }}}',
            ]
        );
        $this->end_controls_section();


        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->typography_style($this, 'Slider Text', '.content h1 span');

        $cipher_init->icon_style($this, 'Icon', '.content h1 span i');

        $cipher_init->section_style($this, 'Slider Body', '.text-moving-sec-s2');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
        $list = $settings['list'] ? $settings['list'] : [];
?>
        <div class="text-moving-sec-s2">
            <div class="text-moving">
                <div class="marquee">
                    <div class="track">
                        <div class="content">
                            <h1>
                                <?php
                                foreach ($list as $item) {
                                ?>
                                    <?php if (!empty($item['list_title_one'])): ?><span><?php echo esc_html($item['list_title_one']); ?></span><?php endif; ?>
                                    <?php if (!empty($item['list_title_two'])): ?><span><?php echo esc_html($item['list_title_two']); ?><?php if (!empty($item['icon_class'])): ?><i class="<?php echo esc_attr($item['icon_class']) ?>"></i><?php endif; ?></span><?php endif; ?>
                                <?php
                                }
                                ?>

                            </h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Text_Slider());
