<?php

namespace Elementor;

class Cipher_Video_Lightbox extends Widget_Base
{
    public function get_name(): string
    {
        return 'init-video-lightbox';
    }

    public function get_title(): string
    {
        return esc_html__('Video Lightbox', 'cipher-core');
    }

    public function get_icon(): string
    {
        return 'cipher-custom-icon';
    }

    public function get_categories(): array
    {
        return ['cipher_widgets'];
    }

    public function get_keywords(): array
    {
        return ['video', 'video-lightbox', 'cipher'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content' ,'cipher-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'poster_image',
            [
                'label' => esc_html__('Poster Image' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'video_url',
            [
                'label' => esc_html__('Vidro Url' ,'cipher-core'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        // Cipher_Elementor_Widget_Init instance
        $cipher_init = \Cipher_Elementor_Widget_Init::getInstance();

        $cipher_init->button_style($this, 'Icon Style', '.video-btn');
    }

    protected function render(): void
    {
        $settings = $this->get_settings_for_display();
?>
        <div class="video-area">
            <div class="container">
                <div class="video-img">
                    <?php echo wp_get_attachment_image($settings['poster_image']['id'], 'full'); ?>
                    <div class="video-btn">
                        <a href="<?php echo esc_url($settings['video_url']['url']); ?>" class="video-btn" data-type="iframe"></a>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new Cipher_Video_Lightbox());
