<?php

/*===== Post Type: header footer builder. =====*/
if (!function_exists('cipher_core_register_header_and_footer')) {
	function cipher_core_register_header_and_footer()
	{
		register_post_type(
			'cipher_hf',
			array(
				'labels' => array(
					'name' => __('Headers & Footers', 'cipher-core'),
					'singular_name' => __('Header & Footer', 'cipher-core'),
				),
				'public' => true,
				'rewrite' => array('slug' => 'header_footer'),
				'publicly_queryable' => true,
				'show_in_menu'      => true,
				'menu_position' => 31,
				'can_export' => true,
				'menu_icon' => 'dashicons-align-wide',
				'supports' => ['title', 'elementor']
			)
		);
	}
	add_action('init', 'cipher_core_register_header_and_footer');
}


/*===== Post Type: Cipher Serivce  =====*/
if (!function_exists('cipher_core_register_services')) {
	function cipher_core_register_services()
	{
		$labels = [
			"name" => esc_html__("Services", "cipher"),
			"singular_name" => esc_html__("service", "cipher"),
			'add_new'               => __('Add Service', 'cipher-core'),
			'add_new_item'          => __('Add Service', 'cipher-core'),
		];

		$args = [
			"label" => esc_html__("Services", "cipher"),
			"labels" => $labels,
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"rest_namespace" => "wp/v2",
			"has_archive" => false,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"can_export" => true,
			"rewrite" => ["slug" => "cipher_service", "with_front" => true],
			"query_var" => true,
			"menu_position" => 31,
			"menu_icon" => "dashicons-sticky",
			"supports" => ["title", "thumbnail", "elementor"],
			"show_in_graphql" => false,
		];

		register_post_type("cipher_service", $args);
	}
	add_action('init', 'cipher_core_register_services');
}

/*===== Post Type: Cipher Portfolio =====*/
if (!function_exists('cipher_core_register_portfolio')) {
	function cipher_core_register_portfolio()
	{
		$labels = [
			"name" => esc_html__("Portfolio", "cipher"),
			"singular_name" => esc_html__("portfolio", "cipher"),
			'add_new'               => __('Add Portfolio', 'cipher-core'),
			'add_new_item'          => __('Add Portfolio', 'cipher-core'),
		];

		$args = [
			"label" => esc_html__("Portfolio", "cipher"),
			"labels" => $labels,
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"rest_namespace" => "wp/v2",
			"has_archive" => false,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"can_export" => true,
			"rewrite" => ["slug" => "cipher_portfolio", "with_front" => true],
			"query_var" => true,
			"menu_position" => 31,
			"menu_icon" => "dashicons-sticky",
			"supports" => ["title", "thumbnail", "elementor"],
			"show_in_graphql" => false,
		];

		register_post_type("cipher_portfolio", $args);
	}
	add_action('init', 'cipher_core_register_portfolio');
}

/*===== Post Type: Cipher Portfolio =====*/
if (!function_exists('cipher_core_register_team')) {
	function cipher_core_register_team()
	{
		$labels = [
			"name" => esc_html__("Team", "cipher"),
			"singular_name" => esc_html__("Team", "cipher"),
			'add_new'               => __('Add Team', 'cipher-core'),
			'add_new_item'          => __('Add Team', 'cipher-core'),
		];

		$args = [
			"label" => esc_html__("Team", "cipher"),
			"labels" => $labels,
			"description" => "",
			"public" => true,
			"publicly_queryable" => true,
			"show_ui" => true,
			"show_in_rest" => true,
			"rest_base" => "",
			"rest_controller_class" => "WP_REST_Posts_Controller",
			"rest_namespace" => "wp/v2",
			"has_archive" => false,
			"show_in_menu" => true,
			"show_in_nav_menus" => true,
			"delete_with_user" => false,
			"exclude_from_search" => false,
			"capability_type" => "post",
			"map_meta_cap" => true,
			"hierarchical" => false,
			"can_export" => true,
			"rewrite" => ["slug" => "cipher_team", "with_front" => true],
			"query_var" => true,
			"menu_position" => 31,
			"menu_icon" => "dashicons-sticky",
			"supports" => ["title", "thumbnail", "elementor"],
			"show_in_graphql" => false,
		];

		register_post_type("cipher_team", $args);
	}
	add_action('init', 'cipher_core_register_team');
}

/*===== Taxonomy: Service Categories.=====*/
function cipher_service_category()
{

	$args = [
		"label" => esc_html__("Categories", "cipher"),
		"labels" => [
			"name" => esc_html__("Categories", "cipher"),
			"singular_name" => esc_html__("Category", "cipher"),
		],
		"public" => true,
		"publicly_queryable" => true,
		"hierarchical" => true,
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => ['slug' => 'service_category', 'with_front' => true,],
		"show_admin_column" => false,
		"show_in_rest" => true,
		"show_tagcloud" => false,
		"can_export" => true,
		"rest_base" => "service_category",
		"rest_controller_class" => "WP_REST_Terms_Controller",
		"rest_namespace" => "wp/v2",
		"show_in_quick_edit" => false,
		"sort" => false,
		"show_in_graphql" => false,
	];
	register_taxonomy("service_category", ["cipher_service"], $args);
}
add_action('init', 'cipher_service_category');


/*===== Taxonomy: Portfolios Categories.=====*/
function cipher_portfolio_category()
{

	$args = [
		"label" => esc_html__("Categories", "cipher"),
		"labels" => [
			"name" => esc_html__("Categories ", "cipher"),
			"singular_name" => esc_html__("Categorie", "cipher"),
		],
		"public" => true,
		"publicly_queryable" => true,
		"hierarchical" => true,
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => ['slug' => 'portfolio_category', 'with_front' => true,],
		"show_admin_column" => false,
		"show_in_rest" => true,
		"show_tagcloud" => false,
		"can_export" => true,
		"rest_base" => "portfolio_category",
		"rest_controller_class" => "WP_REST_Terms_Controller",
		"rest_namespace" => "wp/v2",
		"show_in_quick_edit" => false,
		"sort" => false,
		"show_in_graphql" => false,
	];
	register_taxonomy("portfolio_category", ["cipher_portfolio"], $args);
}
add_action('init', 'cipher_portfolio_category');
