<?php
/*===== Header option to theme option-> header =====*/
if (!function_exists('cipher_header_styles')) {
    function cipher_header_styles()
    {
        $cipher_header = ['' => esc_html__('Default', 'cipher-core')];
        $cipher_headers = get_posts(
            [
                'post_type' => 'cipher_hf',
                'posts_per_page' => -1,
                'orderby' => 'name',
                'order' => 'ASC',
                'meta_query' => array(
                    array(
                        'key' => 'choose-header-footer-opt',
                        'value' => 'header_key',
                        'compare' => '='
                    )
                )
            ]
        );
        foreach ($cipher_headers as $value) {
            $cipher_header[$value->ID] = $value->post_title;
        }
        return $cipher_header;
    };
}

/*===== Footer option to theme option-> footer =====*/
if (!function_exists('cipher_footer_styles')) {
    function cipher_footer_styles()
    {
        $cipher_footer = ['' => esc_html__('Default', 'cipher-core')];
        $cipher_footers = get_posts(
            [
                'post_type' => 'cipher_hf',
                'posts_per_page' => -1,
                'orderby' => 'name',
                'order' => 'ASC',
                'meta_query' => array(
                    array(
                        'key' => 'choose-header-footer-opt',
                        'value' => 'footer_key',
                        'compare' => '='
                    )
                )
            ]
        );
        foreach ($cipher_footers as $value) {
            $cipher_footer[$value->ID] = $value->post_title;
        }
        return $cipher_footer;
    };
};

/*===== Custom body class from Elementor page settings =====*/
if (!function_exists('cipher_custom_body_class')) {
    add_filter('body_class', 'cipher_custom_body_class', 10, 2);
    function cipher_custom_body_class($classes, $class)
    {

        if (!is_singular()) {
            return $classes;
        }

        $post_id = get_the_ID();

        // Elementor page settings meta
        $page_settings = get_post_meta($post_id, '_elementor_page_settings', true);

        if (empty($page_settings) || !is_array($page_settings)) {
            return $classes;
        }

        /**
         * Select dropdown class
         * select_body => home_v1, home_v2 etc
         */
        if (!empty($page_settings['select_body'])) {
            $classes[] = sanitize_html_class($page_settings['select_body']);
        }

        /**
         * Text field body class
         */
        if (!empty($page_settings['body_class'])) {

            // multiple class support
            $custom_classes = explode(' ', $page_settings['body_class']);

            foreach ($custom_classes as $custom_class) {
                $classes[] = sanitize_html_class($custom_class);
            }
        }

        return $classes;
    }
}

/*===== Get pages =====*/
if (!function_exists('cipher_get_pages')) {
    function cipher_get_pages()
    {

        $options = [];

        $pages = get_posts([
            'post_type'      => 'page',
            'posts_per_page' => -1,
            'post_status'    => 'publish',
        ]);

        if (!empty($pages)) {
            foreach ($pages as $page) {
                $options[$page->post_name] = $page->post_title;
            }
        }

        return $options;
    }
}

/*===== Get Current Page =====*/
if (!function_exists('cipher_get_current_page')) {
    function cipher_get_current_page()
    {

        $options = [];

        if (is_admin() && isset($_GET['post'])) {

            $post_id = absint($_GET['post']);
            $post    = get_post($post_id);

            if ($post && $post->post_type === 'page') {
                $options[$post->post_name] = $post->post_title;
            }
        }

        return $options;
    }
}

/*===== Post share function =====*/
if (!function_exists('cipher_post_share')) {
    function cipher_post_share()
    {

        $post_title   = htmlspecialchars(urlencode(html_entity_decode(esc_attr(get_the_title()), ENT_COMPAT, 'UTF-8')), ENT_COMPAT, 'UTF-8');
        $post_id    = get_the_ID();
        $post_url   = get_permalink($post_id);
?>
        <ul>
            <li>
                <a href="https://www.facebook.com/sharer.php?u=<?php echo rawurlencode(esc_url($post_url)); ?>" rel="external" target="_blank" class="fb-share">
                    <i class="ti-facebook"></i>
                </a>
            </li>

            <li>
                <a href="https://twitter.com/share?text=<?php echo wp_strip_all_tags($post_title); ?>&amp;url=<?php echo rawurlencode(esc_url($post_url)); ?>" rel="external" target="_blank" class="twitter-share">
                    <i class="ti-twitter-alt"></i>
                </a>
            </li>

            <li>
                <a href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo rawurlencode(esc_url($post_url)); ?>&amp;title=<?php echo wp_strip_all_tags($post_title); ?>&amp;summary=<?php echo urlencode(wp_trim_words(strip_shortcodes(get_the_content($post_id)), 40)); ?>&amp;source=<?php echo esc_url(home_url('/')); ?>" rel="external" target="_blank" class="linkedin-share">
                    <i class="ti-linkedin"></i>
                </a>
            </li>
            <li>
                <a href="https://www.instagram.com/?url=<?php echo rawurlencode(esc_url($post_url)); ?>" rel="external" target="_blank" class="instagram-share">
                    <i class="ti-instagram"></i>
                </a>
            </li>
        </ul>
<?php
    }
}

/*===== reading time =====*/
if (!function_exists('cipher_reading_time')) {
    function cipher_reading_time()
    {
        $content = get_post_field('post_content', get_the_ID());
        $word_count = str_word_count(strip_tags($content));
        $readingtime = ceil($word_count / 200);
        $totalreadingtime = $readingtime . ' ' . esc_html__('Min Read', 'cipher');
        echo esc_html($totalreadingtime);
    }
}


/*===== Get services post =====*/
if (!function_exists('cipher_get_service')) {
    function cipher_get_service()
    {
        $get_posts = get_posts(array(
            'post_type' => 'cipher_service',
            'numberposts' => -1,
        ));
        $options = [];
        foreach ($get_posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}

/*===== Get project post =====*/
if (!function_exists('cipher_get_portfolio')) {
    function cipher_get_portfolio()
    {
        $get_posts = get_posts(array(
            'post_type' => 'cipher_portfolio',
            'numberposts' => -1,
        ));
        $options = [];
        foreach ($get_posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}


/*===== Get team post =====*/
if (!function_exists('cipher_get_team')) {
    function cipher_get_team()
    {
        $get_posts = get_posts(array(
            'post_type' => 'cipher_team',
            'numberposts' => -1,
        ));
        $options = [];
        foreach ($get_posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}


/*===== Get blog post =====*/
if (!function_exists('cipher_get_blog')) {
    function cipher_get_blog()
    {
        $get_posts = get_posts(array(
            'post_type' => 'post',
            'numberposts' => -1,
        ));
        $options = [];
        foreach ($get_posts as $post) {
            $options[$post->ID] = get_the_title($post->ID);
        }
        return $options;
    }
}


/*===== Post Type: Service Category =====*/
if (!function_exists('ciper_service_category')) {
    function ciper_service_category()
    {
        $categories = get_terms(
            array(
                'taxonomy' => 'service_category',
                'hide_empty' => false,
            )
        );

        $options = [];
        if (!empty($categories) && !is_wp_error($categories)) {
            foreach ($categories as $category) {
                $options[$category->term_id] = $category->name;
            }
        }
        return $options;
    }
}

/*===== Menu selector =====*/
if (!function_exists('service_cipher_menu_selectorcategory')) {
    function cipher_menu_selector()
    {
        $menus = wp_get_nav_menus();
        $items = array();
        $i     = 0;
        foreach ($menus as $menu) {
            if ($i == 0) {
                $default = $menu->slug;
                $i++;
            }
            $items[$menu->slug] = $menu->name;
        }
        return $items;
    }
}
