<?php

// Enable SVG uploads
function themex_mime_types($mimes)
{
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'themex_mime_types');

// Sanitize SVG files
function themex_sanitize_svg($file)
{
    if ($file['type'] == 'image/svg+xml') {
        $svg = simplexml_load_file($file['tmp_name']);

        if ($svg === false) {
            $file['error'] = 'Invalid SVG file';
            return $file;
        }

        // Remove any potentially dangerous elements or attributes
        $sanitized_svg = themex_sanitize_svg_content($svg);

        // Save the sanitized SVG back to the file
        file_put_contents($file['tmp_name'], $sanitized_svg->asXML());
    }

    return $file;
}
add_filter('wp_handle_upload_prefilter', 'themex_sanitize_svg');

// Sanitize SVG content
function themex_sanitize_svg_content($svg)
{
    $dangerous_elements = ['script', 'iframe', 'object', 'embed'];
    foreach ($dangerous_elements as $element) {
        foreach ($svg->xpath('//' . $element) as $dangerous) {
            unset($dangerous[0]);
        }
    }

    return $svg;
}
