<?php

CSF::createSection($prefix, array(
    'id'     => '404--opt',
    'title'  => esc_html('404 Not Found', 'cipher-core'),
    'icon'   => 'fa fa-question-circle',
    'fields' => array(
        array(
            'id'      => '404-opt-media',
            'type'    => 'media',
            'title'   => esc_html__('404 Image', 'cipher-core'),
            'library' => 'image',
        ),
        array(
            'id'    => '404-img-width',
            'type'  => 'slider',
            'title' => esc_html__('Image Width', 'cipher-core'),
            'default' => 100,
        ),
        array(
            'id'      => 'opt-title-404',
            'type'    => 'textarea',
            'title'   => esc_html__('404 Page Title', 'cipher-core'),
            'default' => esc_html__('Nothing Found', 'cipher-core'),
        ),
        array(
            'id'            => '404-wp-editor',
            'type'          => 'wp_editor',
            'title'         => esc_html__('404 Page Content', 'cipher-core'),
            'tinymce'       => true,
            'quicktags'     => true,
            'media_buttons' => true,
            'height'        => '100px',
            'default'       => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'cipher-core'),
        ),
    )
));
