<?php
// Create a section
CSF::createSection($prefix, array(
    'id'     => 'blog-page-opt',
    'title'  => esc_html__('Blog Page', 'cipher-core'),
    'icon'   => 'fa fa-building',
));

CSF::createSection($prefix, array(
    'parent' => 'blog-page-opt',
    'id'     => 'blog-page-info-opt',
    'icon'  => 'fa fa-pencil-square',
    'title'  => esc_html__('Blog Page', 'cipher-core'),
    'fields' => array(
        array(
            'id'          => 'blog-layout-opt',
            'type'        => 'select',
            'title'       => esc_html__('Blog layout', 'cipher-core'),
            'options'     => array(
                'standard'  => esc_html__('Standard', 'cipher-core'),
                'standard_left_sidebar'  => esc_html__('Standard Left Sidebar', 'cipher-core'),
                'grid-full'  => esc_html__('Grid Full', 'cipher-core'),
            ),
            'default'     => 'standard',
        ),
        array(
            'id'    => 'read-more-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Enable Button', 'cipher-core'),
            'desc' => esc_html__('Show or hide read more button on blog page.', 'cipher-core'),
        ),
        array(
            'id'      => 'read-more-text',
            'type'    => 'text',
            'title'   => 'Text',
            'title' => esc_html__('Read More Text', 'cipher-core'),
            'default' => 'Continue Reading',
            'dependency' => array('read-more-switcher', '==', 'true'),
        ),
        array(
            'id'    => 'excerpt-length',
            'type'  => 'number',
            'title' => esc_html__('Excerpt Length', 'cipher-core'),
            'desc' => esc_html__('Set excerpt length for blog page.', 'cipher-core'),
            'default' => 10,
        ),
    )
));

//metadata info
CSF::createSection($prefix, array(
    'parent' => 'blog-page-opt',
    'title'  => esc_html__('Meta Info', 'cipher-core'),
    'icon'  => 'fa fa-th',
    'fields' => array(
        array(
            'id'    => 'post-tag-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Tag', 'cipher-core'),
            'desc' => esc_html__('Show or hide post tag on blog page.', 'cipher-core'),
            'default' => true,
        ),
        array(
            'id'    => 'post-author-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Author', 'cipher-core'),
            'desc' => esc_html__('Show or hide post tag on blog page.', 'cipher-core'),
            'default' => true,
        ),
        array(
            'id'    => 'post-comments-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Comments', 'cipher-core'),
            'desc' => esc_html__('Show or hide post tag on blog page.', 'cipher-core'),
            'default' => true,
        ),
        array(
            'id'    => 'post-date-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Date', 'cipher-core'),
            'desc' => esc_html__('Show or hide post tag on blog page.', 'cipher-core'),
            'default' => true,
        ),
    )
));

//metadata info
CSF::createSection($prefix, array(
    'parent' => 'blog-page-opt',
    'title'  => esc_html__('Blog Details', 'cipher-core'),
    'icon'  => 'fa fa-th',
    'fields' => array(
        array(
            'id'    => 'post-tag-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Tag', 'cipher-core'),
            'desc' => esc_html__('Show or Hide Post Tag In Featured Image Area', 'cipher-core'),
            'default' => true,
        ),
        array(
            'id'    => 'post-author-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Author', 'cipher-core'),
            'desc' => esc_html__('Show or Hide Author Tag In Featured Image Area', 'cipher-core'),
            'default' => true,
        ),
        array(
            'id'    => 'post-comments-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Comments', 'cipher-core'),
            'desc' => esc_html__('Show or Hide Post Comments In Featured Image Area', 'cipher-core'),
            'default' => true,
        ),
        array(
            'id'    => 'post-date-switcher',
            'type'  => 'switcher',
            'title' => esc_html__('Post Date', 'cipher-core'),
            'desc' => esc_html__('Show or Hide Post Date In Featured Image Area', 'cipher-core'),
            'default' => true,
        ),
    )
));
