<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/*===== Create theme options =====*/
if (class_exists('CSF')) {
    $prefix = 'cipher_csf';
    CSF::createOptions($prefix, array(
        'framework_title' => wp_kses(sprintf(__('Cipher Options <small>v%s</small>', 'cipher-core'), CIPHER_CORE_VERSION), array('small' => array())),
        'menu_title'      => __('Theme Options', 'cipher-core'),
        'menu_slug'       => 'cipher-options',
        'enqueue_webfont'    => true,
        'show_in_customizer' => true,
        'menu_icon' => 'dashicons-category',
        'show_sub_menu'   => false,
        'class'           => 'cipher-theme-option',
        'menu_position'   => 1,
        'footer_text'   => wp_kses(
            __('Developed by: <a target="_blank" href="https://inventxlab.com">Inventxlab</a>', 'cipher-core'),
            array(
                'a'  => array(
                    'href'   => array(),
                    'target' => array()
                ),
            )
        ),
        'async_webfont' => false,
    ));
}
