<?php

// Control core classes for avoid errors
if (class_exists('CSF')) {

    //
    // Set a unique slug-like ID
    $prefix = 'cipher_csf_metabox';
    //
    // Create a metabox
    CSF::createMetabox($prefix, array(
        'title'     => 'My page Options',
        'post_type' => array('page'),
    ));


    // Create a section for breadcrumbs switcher
    CSF::createSection($prefix, array(
        'title'  => 'Breadcrumb Setting',
        'fields' => array(
            array(
                'id'    => 'page-bc-swithcer',
                'type'  => 'switcher',
                'title' => esc_html__('Breadcrumb Option', 'cipher-core'),
                'desc' => esc_html__('Turn on to enable breadcrumb for this page', 'cipher-core'),
                'default' => true,
            ),
            array(
                'id'      => 'page-bc-title',
                'type'    => 'text',
                'title'   => esc_html__('Custom Title', 'cipher-core'),
                'default' => 'Page Title',
                'dependency' => array('page-bc-swithcer', '==', 'true'),
            ),
            array(
                'id'    => 'page-bc-bg-image',
                'type'  => 'media',
                'title' => esc_html__('Background Image', 'cipher-core'),
                'dependency' => array('page-bc-swithcer', '==', 'true'),
            ),
            array(
                'id'    => 'page-bc-shape-image',
                'type'  => 'media',
                'title' => esc_html__('Shape Image', 'cipher-core'),
                'dependency' => array('page-bc-swithcer', '==', 'true'),
            ),
        )
    ));

    // Create a section for page options
    CSF::createSection($prefix, array(
        'title'  => 'Page Setting',
        'fields' => array(
            array(
                'id'    => 'page-title-opt',
                'type'  => 'switcher',
                'title' => esc_html__('Title Option', 'cipher-core'),
                'desc' => esc_html__('Turn on to disable page title for this page', 'cipher-core'),
                'default' => false,
            ),
            array(
                'id'    => 'page-sidebar-switcher',
                'type'  => 'switcher',
                'title' => esc_html__('Disable Sidebar', 'cipher-core'),
                'desc' => esc_html__('Turn on to disable sidebar for this page', 'cipher-core'),
                'default' => true,
            ),
        )
    ));

    // Create a section for page header options
    CSF::createSection($prefix, array(
        'title'  => 'Header Setting',
        'fields' => array(
            array(
                'id'         => 'page-header-opt',
                'type'       => 'select',
                'title'      => esc_html__('Choose Header Style', 'cipher-core'),
                'desc'       => esc_html__('Select Header Style for this page', 'cipher-core'),
                'options' => cipher_header_styles(),
            ),
        )
    ));

    // Create a section for page footer options
    CSF::createSection($prefix, array(
        'title'  => 'Footer Setting',
        'fields' => array(
            array(
                'id'         => 'page-footer-opt',
                'type'       => 'select',
                'title'      => esc_html__('Choose Footer Style', 'cipher-core'),
                'desc'       => esc_html__('Select Footer Style for this page', 'cipher-core'),
                'options' => cipher_footer_styles(),
            ),
        )
    ));
}
