<?php

// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a metabox for post format gallery
    $clinfyx_gallery_post_format = 'cipher_post_gallery_metabox';
    CSF::createMetabox($clinfyx_gallery_post_format, array(
        'title'     => esc_html__('Gallery Post Format Option', 'cipher-core'),
        'post_type' => array('post'),
        'post_formats' => array('gallery'),
    ));
    CSF::createSection($clinfyx_gallery_post_format, array(
        // 'title'  => esc_html__('Gallery', 'cipher-core'),
        'fields' => array(
            array(
                'id'          => 'post_gallery',
                'type'        => 'gallery',
                'title'       => esc_html__('Gallery', 'cipher-core'),
                'add_title'   => esc_html__('Add Images', 'cipher-core'),
                'edit_title'  => esc_html__('Edit Images', 'cipher-core'),
                'clear_title' => esc_html__('Remove Images', 'cipher-core'),
                'desc'        => esc_html__('Upload or add images to the gallery.', 'cipher-core'),
            ),
        )
    ));

    // Create a metabox for post format video
    $clinfyx_video_post_format = 'cipher_post_video_metabox';
    CSF::createMetabox($clinfyx_video_post_format, array(
        'title'     => esc_html__('Video Post Format Option', 'cipher-core'),
        'post_type' => array('post'),
        'post_formats' => array('video'),
    ));
    CSF::createSection($clinfyx_video_post_format, array(
        // 'title'  => esc_html__('Video', 'cipher-core'),
        'fields' => array(
            array(
                'id'      => 'post-video',
                'type'    => 'text',
                'title'   => esc_html__('Video URL', 'cipher-core'),
                'desc'    => esc_html__('Paste your video Url', 'cipher-core'),
                'default' => 'https://www.youtube.com/watch?v=7e90gBu4pas',
            ),
        )
    ));


    // Create a metabox for post format audio
    $clinfyx_audio_post_format = 'cipher_post_audio_metabox';
    CSF::createMetabox($clinfyx_audio_post_format, array(
        'title'     => esc_html__('Audio Post Format Option', 'cipher-core'),
        'post_type' => array('post'),
        'post_formats' => array('audio'),
    ));
    CSF::createSection($clinfyx_audio_post_format, array(
        // 'title'  => esc_html__('Audio', 'cipher-core'),
        'fields' => array(
            array(
                'id'      => 'post-audio',
                'type'  => 'code_editor',
                'settings' => array(
                    'theme'  => 'monokai',
                    'mode'   => 'htmlmixed',
                ),
                'title'   => esc_html__('Audio URL', 'cipher-core'),
                'desc'    => esc_html__('Paste sound cloud audio embed code here', 'cipher-core'),
                'default' => '',
            ),
        )
    ));



    // Create a metabox for post format link
    $clinfyx_link_post_format = 'cipher_post_link_metabox';
    CSF::createMetabox($clinfyx_link_post_format, array(
        'title'     => esc_html__('Link Post Format Option', 'cipher-core'),
        'post_type' => array('post'),
        'post_formats' => array('link'),
    ));
    CSF::createSection($clinfyx_link_post_format, array(
        // 'title'  => esc_html__('LInk', 'cipher-core'),
        'fields' => array(
            array(
                'id'      => 'post-link',
                'type'  => 'text',
                'title'   => esc_html__('Link URL', 'cipher-core'),
                'desc'    => esc_html__('Paste Your URL here', 'cipher-core'),
                'default' => 'https://google.com',
            ),
        )
    ));



    // Create a metabox for post format link
    $clinfyx_quote_post_format = 'cipher_post_quote_metabox';
    CSF::createMetabox($clinfyx_quote_post_format, array(
        'title'     => esc_html__('Quote Post Format Option', 'cipher-core'),
        'post_type' => array('post'),
        'post_formats' => array('quote'),
    ));
    CSF::createSection($clinfyx_quote_post_format, array(
        // 'title'  => esc_html__('quote', 'cipher-core'),
        'fields' => array(
            array(
                'id'      => 'post-quote-desc',
                'type'  => 'textarea',
                'title'   => esc_html__('Quote Description', 'cipher-core'),
                'default' => 'Write Your Post Quote Here',
            ),
            array(
                'id'      => 'post-quote-author',
                'type'  => 'text',
                'title'   => esc_html__('Quote Author', 'cipher-core'),
                'default' => 'Write Your Post Quote Author Name',
            ),
        )
    ));
}
