<?php
if (!defined('ABSPATH')) {
    exit;
}

class Cipher_Core_About_Widget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'cipher_about_widget',
            esc_html__('Cipher About Me', 'cipher-core'),
            array(
                'description' => esc_html__('About Me Widget', 'cipher-core')
            )
        );
    }

    /* ==========================
     * Frontend Output
     * ========================== */
    public function widget($args, $instance)
    {
        $title       = !empty($instance['title']) ? $instance['title'] : esc_html__('About Me', 'cipher-core');
        $image       = !empty($instance['image']) ? $instance['image'] : '';
        $name        = !empty($instance['name']) ? $instance['name'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $facebook    = !empty($instance['facebook']) ? $instance['facebook'] : '';
        $twitter     = !empty($instance['twitter']) ? $instance['twitter'] : '';
        $linkedin    = !empty($instance['linkedin']) ? $instance['linkedin'] : '';

        echo $args['before_widget'];
?>

        <div class="blog-sidebar">
            <div class="widget about-widget">

                <?php if (!empty($title)) : ?>
                    <h3><?php echo esc_html($title); ?></h3>
                <?php endif; ?>

                <?php if (!empty($image)) : ?>
                    <div class="img-holder">
                        <img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_attr($name); ?>">
                    </div>
                <?php endif; ?>

                <?php if (!empty($name)) : ?>
                    <h4><?php echo esc_html($name); ?></h4>
                <?php endif; ?>

                <?php if (!empty($description)) : ?>
                    <p><?php echo esc_html($description); ?></p>
                <?php endif; ?>

                <?php if ($facebook || $twitter || $linkedin) : ?>
                    <div class="social">
                        <ul class="clearfix">
                            <?php if ($facebook) : ?>
                                <li><a href="<?php echo esc_url($facebook); ?>"><i class="ti-facebook"></i></a></li>
                            <?php endif; ?>

                            <?php if ($twitter) : ?>
                                <li><a href="<?php echo esc_url($twitter); ?>"><i class="ti-twitter-alt"></i></a></li>
                            <?php endif; ?>

                            <?php if ($linkedin) : ?>
                                <li><a href="<?php echo esc_url($linkedin); ?>"><i class="ti-linkedin"></i></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    <?php
        echo $args['after_widget'];
    }

    /* ==========================
     * Backend Form
     * ========================== */
    public function form($instance)
    {
        $title       = $instance['title'] ?? esc_html__('About Me', 'cipher-core');
        $image       = $instance['image'] ?? '';
        $name        = $instance['name'] ?? '';
        $description = $instance['description'] ?? '';
        $facebook    = $instance['facebook'] ?? '';
        $twitter     = $instance['twitter'] ?? '';
        $linkedin    = $instance['linkedin'] ?? '';
    ?>

        <p>
            <label><?php esc_html_e('Title:', 'cipher-core'); ?></label>
            <input class="widefat" type="text"
                name="<?php echo esc_attr($this->get_field_name('title')); ?>"
                value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Image URL:', 'cipher-core'); ?></label>
            <input class="widefat" type="text"
                name="<?php echo esc_attr($this->get_field_name('image')); ?>"
                value="<?php echo esc_url($image); ?>">
            <small><?php esc_html_e('Upload image and paste URL here', 'cipher-core'); ?></small>
        </p>

        <p>
            <label><?php esc_html_e('Name:', 'cipher-core'); ?></label>
            <input class="widefat" type="text"
                name="<?php echo esc_attr($this->get_field_name('name')); ?>"
                value="<?php echo esc_attr($name); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Description:', 'cipher-core'); ?></label>
            <textarea class="widefat" rows="4"
                name="<?php echo esc_attr($this->get_field_name('description')); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>

        <p>
            <label><?php esc_html_e('Facebook URL:', 'cipher-core'); ?></label>
            <input class="widefat" type="url"
                name="<?php echo esc_attr($this->get_field_name('facebook')); ?>"
                value="<?php echo esc_url($facebook); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Twitter URL:', 'cipher-core'); ?></label>
            <input class="widefat" type="url"
                name="<?php echo esc_attr($this->get_field_name('twitter')); ?>"
                value="<?php echo esc_url($twitter); ?>">
        </p>

        <p>
            <label><?php esc_html_e('LinkedIn URL:', 'cipher-core'); ?></label>
            <input class="widefat" type="url"
                name="<?php echo esc_attr($this->get_field_name('linkedin')); ?>"
                value="<?php echo esc_url($linkedin); ?>">
        </p>

<?php
    }

    /* ==========================
     * Save Data
     * ========================== */
    public function update($new, $old)
    {
        return array(
            'title'       => sanitize_text_field($new['title']),
            'image'       => esc_url_raw($new['image']),
            'name'        => sanitize_text_field($new['name']),
            'description' => sanitize_textarea_field($new['description']),
            'facebook'    => esc_url_raw($new['facebook']),
            'twitter'     => esc_url_raw($new['twitter']),
            'linkedin'    => esc_url_raw($new['linkedin']),
        );
    }
}
