<?php
class Cipher_Core_Recent_Post_Widget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'cipher_recent_posts_widget',
            esc_html__('Cipher Recent Posts', 'cipher-core'),
            array(
                'description' => esc_html__('Recent Posts Widget (Markup Preserved)', 'cipher-core')
            )
        );
    }

    // Frontend Output
    public function widget($args, $instance)
    {
        $title    = !empty($instance['title']) ? $instance['title'] : esc_html__('Recent Post', 'cipher-core');
        $number   = !empty($instance['number']) ? absint($instance['number']) : 3;
        $category = !empty($instance['category']) ? absint($instance['category']) : 0;

        $query_args = array(
            'post_type'           => 'post',
            'posts_per_page'      => $number,
            'ignore_sticky_posts' => true,
        );

        if ($category) {
            $query_args['cat'] = $category;
        }

        $recent_query = new WP_Query($query_args);

        if (!$recent_query->have_posts()) {
            return;
        }
?>
        <section class="blog-sidebar" id="">
            <div class="recent-post widget">
                <?php if (!empty($title)): ?>
                    <h3><?php echo esc_html($title); ?></h3>
                <?php endif; ?>
                <?php while ($recent_query->have_posts()) : $recent_query->the_post(); ?>

                    <div class="post">
                        <div class="post-img">
                            <a href="<?php the_permalink(); ?>">
                                <?php if (has_post_thumbnail()) : ?>
                                    <?php the_post_thumbnail('thumbnail'); ?>
                                <?php else : ?>
                                    <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/img/placeholder.png'); ?>" alt="<?php the_title_attribute(); ?>">
                                <?php endif; ?>
                            </a>
                        </div>
                        <div class="post-content">
                            <?php if (function_exists('cipher_post_parent_category')): ?>
                                <ul>
                                    <li><i class="ti-folder"></i></li>
                                    <li><?php cipher_post_parent_category(); ?></li>
                                </ul>
                            <?php endif; ?>
                            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        </div>
                    </div>
                <?php endwhile; ?>

            </div>
        </section>
    <?php
        wp_reset_postdata();
    }

    // Backend Form
    public function form($instance)
    {
        $title    = $instance['title'] ?? esc_html__('Recent Post', 'cipher-core');
        $number   = $instance['number'] ?? 3;
        $category = $instance['category'] ?? 0;

        $categories = get_categories();
    ?>
        <p>
            <label><?php esc_html_e('Title:', 'cipher-core'); ?></label>
            <input class="widefat" type="text"
                name="<?php echo $this->get_field_name('title'); ?>"
                value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Number of posts:', 'cipher-core'); ?></label>
            <input class="tiny-text" type="number"
                name="<?php echo $this->get_field_name('number'); ?>"
                value="<?php echo esc_attr($number); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Filter by category:', 'cipher-core'); ?></label>
            <select class="widefat" name="<?php echo $this->get_field_name('category'); ?>">
                <option value="0"><?php esc_html_e('All Categories', 'cipher-core'); ?></option>
                <?php foreach ($categories as $cat) : ?>
                    <option value="<?php echo esc_attr($cat->term_id); ?>" <?php selected($category, $cat->term_id); ?>>
                        <?php echo esc_html($cat->name); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </p>
<?php
    }

    // Save
    public function update($new, $old)
    {
        return array(
            'title'    => sanitize_text_field($new['title']),
            'number'   => absint($new['number']),
            'category' => absint($new['category']),
        );
    }
}
