<?php
class Cipher_Core_Search_Widget extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'cipher_core_search_widget',
            esc_html__('Cipher Search Widget', 'cipher-core'),
            array(
                'description' => esc_html__('A Search Widget for Cipher Theme', 'cipher-core')
            )
        );
    }

    // Frontend Output
    public function widget($args, $instance)
    {
        echo $args['before_widget'];

        // Widget Title
        if (!empty($instance['title'])) {
            echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'];
        }
?>
        <div class="blog-sidebar">
            <div class="search-widget widget">
                <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                    <div>
                        <input type="search" name="s" placeholder="<?php esc_attr_e('Search Blog', 'cipher-core'); ?>" value="<?php echo get_search_query(); ?>">
                        <button type="submit"><i class="ti-search"></i></button>
                    </div>
                </form>
            </div>
        </div>
    <?php
        echo $args['after_widget'];
    }

    // Backend Form
    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Search', 'cipher-core');
    ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                <?php esc_html_e('Title:', 'cipher-core'); ?>
            </label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
<?php
    }

    // Save Widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        return $instance;
    }
}
