<?php
if (!defined('ABSPATH')) {
    exit;
}

class Cipher_Core_Post_Taxonomy extends WP_Widget
{
    public function __construct()
    {
        parent::__construct(
            'cipher_core_post_taxonomy_widget',
            esc_html__('Cipher Post Taxonomy', 'cipher-core'),
            array(
                'description' => esc_html__('Post Category / Taxonomy Widget', 'cipher-core')
            )
        );
    }

    /* =============================
     * Frontend Output
     * ============================= */
    public function widget($args, $instance)
    {
        $title      = !empty($instance['title']) ? $instance['title'] : esc_html__('Category', 'cipher-core');
        $taxonomy   = !empty($instance['taxonomy']) ? $instance['taxonomy'] : 'category';
        $number     = !empty($instance['number']) ? absint($instance['number']) : 5;
        $hide_empty = !empty($instance['hide_empty']);

        $terms = get_terms(array(
            'taxonomy'   => $taxonomy,
            'number'     => $number,
            'hide_empty' => $hide_empty,
        ));

        if (empty($terms) || is_wp_error($terms)) {
            return;
        }

        echo $args['before_widget'];
?>

        <div class="blog-sidebar">
            <div class="category-widget widget">
                <?php if (!empty($title)) : ?>
                    <h3><?php echo esc_html($title); ?></h3>
                <?php endif; ?>
                <ul>
                    <?php foreach ($terms as $term) : ?>
                        <li>
                            <a href="<?php echo esc_url(get_term_link($term)); ?>">
                                <span>
                                    <i class="icon-arrow"></i>
                                    <?php echo esc_html($term->name); ?>
                                </span>
                                (<?php echo esc_html($term->count); ?>)
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>

    <?php
        echo $args['after_widget'];
    }

    /* =============================
     * Backend Form
     * ============================= */
    public function form($instance)
    {
        $title      = $instance['title'] ?? esc_html__('Category', 'cipher-core');
        $taxonomy   = $instance['taxonomy'] ?? 'category';
        $number     = $instance['number'] ?? 5;
        $hide_empty = !empty($instance['hide_empty']);

        $taxonomies = get_taxonomies(array('public' => true), 'objects');
    ?>

        <p>
            <label><?php esc_html_e('Title:', 'cipher-core'); ?></label>
            <input class="widefat" type="text"
                name="<?php echo esc_attr($this->get_field_name('title')); ?>"
                value="<?php echo esc_attr($title); ?>">
        </p>

        <p>
            <label><?php esc_html_e('Taxonomy:', 'cipher-core'); ?></label>
            <select class="widefat"
                name="<?php echo esc_attr($this->get_field_name('taxonomy')); ?>">
                <?php foreach ($taxonomies as $tax) : ?>
                    <option value="<?php echo esc_attr($tax->name); ?>" <?php selected($taxonomy, $tax->name); ?>>
                        <?php echo esc_html($tax->label); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </p>

        <p>
            <label><?php esc_html_e('Number of items:', 'cipher-core'); ?></label>
            <input class="tiny-text" type="number"
                name="<?php echo esc_attr($this->get_field_name('number')); ?>"
                value="<?php echo esc_attr($number); ?>">
        </p>

        <p>
            <input type="checkbox"
                name="<?php echo esc_attr($this->get_field_name('hide_empty')); ?>"
                <?php checked($hide_empty); ?>>
            <label><?php esc_html_e('Hide empty categories', 'cipher-core'); ?></label>
        </p>

<?php
    }

    /* =============================
     * Save Widget Data
     * ============================= */
    public function update($new, $old)
    {
        return array(
            'title'      => sanitize_text_field($new['title']),
            'taxonomy'   => sanitize_text_field($new['taxonomy']),
            'number'     => absint($new['number']),
            'hide_empty' => !empty($new['hide_empty']),
        );
    }
}
