(function ($) {
  "use strict";

  /*===== blog post carousel =====*/
  function BlogPostCarousel($scope, $) {
    const blogPostSlider = new Swiper(".blog-post-slider", {
      spaceBetween: 30,
      loop: true,
      autoplay: {
        delay: 5000,
      },
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
      breakpoints: {
        576: {
          slidesPerView: 1,
        },
        768: {
          slidesPerView: 2,
        },
        992: {
          slidesPerView: 3,
        },
      },
    });
  }

  //service slider one
  function ServiceSliderOne($scope, $) {
    if ($('.service-slide').length > 0) {
      const ServiceSlide = new Swiper(".service-slide", {
        spaceBetween: 30,
        speed: 1300,
        loop: true,
        autoplay: {
          delay: 1300,
          disableOnInteraction: false,
        },
        navigation: {
          nextEl: ".array-prev",
          prevEl: ".array-next",
        },
        breakpoints: {
          1199: {
            slidesPerView: 4,
          },
          991: {
            slidesPerView: 3,
          },
          767: {
            slidesPerView: 2,
          },
          575: {
            slidesPerView: 2,
          },
          400: {
            slidesPerView: 1,
          },
        },
      });
    }
  }

  //image and text carousel
  function ImageAndTextCarousel($scope, $) {
    if ($('.marque-slider').length > 0) {
      const marqueSlider = new Swiper(".marque-slider", {
        slidesPerView: 'auto',
        spaceBetween: 40,
        freemode: true,
        centeredSlides: true,
        loop: true,
        speed: 6000,
        allowTouchMove: false,
        autoplay: {
          delay: 1,
          disableOnInteraction: true,
        },
      });
    }
  }

  //project carousel v1
  function ProjectV1Carousel($scope, $) {
    if ($('.project-slide').length > 0) {
      const ProjectSlide = new Swiper(".project-slide", {
        spaceBetween: 30,
        speed: 1300,
        loop: true,
        autoplay: {
          delay: 1300,
          disableOnInteraction: false,
        },
        navigation: {
          nextEl: ".array-prev",
          prevEl: ".array-next",
        },
        breakpoints: {
          1199: {
            slidesPerView: 5,
          },
          991: {
            slidesPerView: 4,
          },
          767: {
            slidesPerView: 3,
          },
          575: {
            slidesPerView: 2,
          },
          400: {
            slidesPerView: 1,
          },
        },
      });
    }
  }

  //project carousel v2
  function ProjectV2Carousel($scope, $) {
    if ($('.project-slide-3').length > 0) {
      const ProjectSlide3 = new Swiper(".project-slide-3", {
        spaceBetween: 30,
        speed: 1300,
        loop: true,
        autoplay: {
          delay: 1300,
          disableOnInteraction: false,
        },
        navigation: {
          nextEl: ".array-prev",
          prevEl: ".array-next",
        },
        breakpoints: {
          1199: {
            slidesPerView: 4,
          },
          991: {
            slidesPerView: 4,
          },
          767: {
            slidesPerView: 3,
          },
          575: {
            slidesPerView: 2,
          },
          400: {
            slidesPerView: 1,
          },
        },
      });
    }
  }

  //secton counter
  function SectionCounter($scope, $) {
    if ($('.brand-slide').length > 0) {
      const BrandSlide = new Swiper(".brand-slide", {
        spaceBetween: 30,
        speed: 1300,
        loop: true,
        autoplay: {
          delay: 1300,
          disableOnInteraction: false,
        },
        navigation: {
          nextEl: ".array-prev",
          prevEl: ".array-next",
        },
        breakpoints: {
          1600: {
            slidesPerView: 7,
          },
          1399: {
            slidesPerView: 6,
          },
          1199: {
            slidesPerView: 5,
          },
          991: {
            slidesPerView: 4,
          },
          767: {
            slidesPerView: 3,
          },
          575: {
            slidesPerView: 2,
          },
          400: {
            slidesPerView: 1,
          },
        },
      });
    }

    //counter up
    $(".count").counterUp({
      delay: 15,
      time: 4000,
    });
  }

  //testimonial V1
  function TestimonialV1($scope, $) {
    if ($('.testi-top-slider').length > 0) {
      const testiTopSlider = new Swiper(".testi-top-slider", {
        spaceBetween: 30,
        speed: 1000,
        loop: true,
        direction: 'vertical',
        centeredSlides: true,
        autoplay: {
          delay: 1300,
          disableOnInteraction: false,
        },
        navigation: {
          nextEl: ".array-prev",
          prevEl: ".array-next",
        },
        breakpoints: {
          991: {
            slidesPerView: 3,
          },
          767: {
            slidesPerView: 2,
          },
          575: {
            slidesPerView: 2,
          },
          400: {
            slidesPerView: 2,
          },
        },
      });
    };

    if ($('.testimonial-content-slide').length > 0) {
      const testimonialContentSlide = new Swiper(".testimonial-content-slide", {
        spaceBetween: 30,
        speed: 1000,
        loop: true,
        autoplay: {
          delay: 1300,
          disableOnInteraction: false,
        },
        navigation: {
          nextEl: ".array-prev",
          prevEl: ".array-next",
        },

      });
    }
  }

  //testimonial V2
  function TestimonialV2($scope, $) {
    if ($('.testimonial-content-slide').length > 0) {
      const testimonialContentSlide = new Swiper(".testimonial-content-slide", {
        spaceBetween: 30,
        speed: 1000,
        loop: true,
        autoplay: {
          delay: 1300,
          disableOnInteraction: false,
        },
        navigation: {
          nextEl: ".array-prev",
          prevEl: ".array-next",
        },

      });
    }
  }

  //testimonial V3
  function TestimonialV3($scope, $) {
    if ($('.testimonial-content-slide').length > 0) {
      const testimonialContentSlide = new Swiper(".testimonial-content-slide", {
        spaceBetween: 30,
        speed: 1000,
        loop: true,
        autoplay: {
          delay: 1300,
          disableOnInteraction: false,
        },
        navigation: {
          nextEl: ".array-prev",
          prevEl: ".array-next",
        },

      });
    }
  }

  //heder v1
  function HeaderV1($scope, $) {
    $('#mobile-menu').meanmenu({
      meanMenuContainer: '.mobile-menu',
      meanScreenWidth: "1199",
      meanExpand: ['<i class="far fa-plus"></i>'],
    });

    /* ================================
      Sidebar Toggle Js Start
   ================================ */

    $(".offcanvas__close,.offcanvas__overlay").on("click", function () {
      $(".offcanvas__info").removeClass("info-open");
      $(".offcanvas__overlay").removeClass("overlay-open");
    });
    $(".sidebar__toggle").on("click", function () {
      $(".offcanvas__info").addClass("info-open");
      $(".offcanvas__overlay").addClass("overlay-open");
    });

    /* ================================
    Body Overlay Js Start
 ================================ */

    $(".body-overlay").on("click", function () {
      $(".offcanvas__area").removeClass("offcanvas-opened");
      $(".df-search-area").removeClass("opened");
      $(".body-overlay").removeClass("opened");
    });

    /* ================================
     Sticky Header Js Start
  ================================ */

    $windowOn.on("scroll", function () {
      if ($(this).scrollTop() > 250) {
        $("#header-sticky").addClass("sticky");
      } else {
        $("#header-sticky").removeClass("sticky");
      }
    });
  }
  /*===== Initialize the Elementor editor hooks =====*/
  $(window).on("elementor/frontend/init", function () {
    if (elementorFrontend.isEditMode()) {

      elementorFrontend.hooks.addAction("frontend/element_ready/blog-post.default", BlogPostCarousel);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-service-one.default", ServiceSliderOne);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-image-text-carousel.default", ImageAndTextCarousel);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-project-v1.default", ProjectV1Carousel);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-project-v3.default", ProjectV2Carousel);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-section-counter.default", SectionCounter);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-testimonial-v1.default", TestimonialV1);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-testimonial-v2.default", TestimonialV2);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-testimonial-v3.default", TestimonialV3);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-header-one.default", HeaderV1);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-header-two.default", HeaderV1);
      elementorFrontend.hooks.addAction("frontend/element_ready/init-header-three.default", HeaderV1);

    }
  });
})(jQuery);
