<?php

/**
 * All Elementor widget init
 * @package trackngo
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
	exit();
}

if (!class_exists('Trackngo_Elementor_Widget_Init')) {

	class Trackngo_Elementor_Widget_Init
	{

		private static $instance;

		public function __construct()
		{

			// Register widget categories
			add_action('elementor/elements/categories_registered', [$this, '_widget_categories']);

			// Register widgets
			add_action('elementor/widgets/register', [$this, '_widget_registered']);

			add_action('elementor/editor/after_enqueue_styles', [$this, 'editor_style']);
			add_action('elementor/documents/register_controls', [$this, 'register_document_controls']);
			// add_action('trackngo_widget_style', [$this, 'widget_style'], 10, 3);
			add_filter('body_class', [$this, 'custom_body_class'], 10, 2);
		}

		// ========= CUSTOM CATEGORY REGISTER ==========
		public function _widget_categories($elements_manager)
		{

			$elements_manager->add_category(
				'trackngo_widgets',
				[
					'title' => __('Trackngo Addons', 'trackngo-core'),
					'icon'  => 'fa fa-plug',
				],
				0
			);

			$elements_manager->add_category(
				'trackngo_hf_widgets',
				[
					'title' => __('Trackngo Header & Footer', 'trackngo-core'),
					'icon'  => 'fa fa-plug',
				],
				1
			);

			error_log('trackngo: categories registered');
		}

		public static function getInstance()
		{
			if (self::$instance === null) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		public function custom_body_class($classes, $css_class)
		{
			$page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers('page');
			$page_settings_model = $page_settings_manager->get_model(get_the_ID());
			$cls = $page_settings_model->get_settings('cls');
			$classes[] = $cls;
			return $classes;
		}

		// ========= LOAD WIDGETS ==========
		public function glob_widget($path, $widgets_manager)
		{
			$widgets = [];

			foreach (glob($path . '*') as $file) {
				$widgets[] = substr($file, strrpos($file, '/') + 1);
			}

			if (is_array($widgets)) {
				foreach ($widgets as $value) {
					if (!empty($value)) {
						require_once $path . $value . '/index.php';
					}
				}
			}
		}

		public function _widget_registered($widgets_manager)
		{
			$this->glob_widget(TRACKNGO_DIR_PATH . '/elementor/widgets/', $widgets_manager);
		}

		public function editor_style()
		{
			$cs_icon = plugins_url('icon.png', __FILE__);
			wp_add_inline_style('elementor-editor', '.elementor-element .icon .trackngo-custom-icon{content:url(' . $cs_icon . ');width:28px;}');
		}

		// ========= PAGE SETTINGS CONTROL ==========
		public function register_document_controls($document)
		{

			if (!$document instanceof \Elementor\Core\DocumentTypes\PageBase || !$document::get_property('has_elements')) {
				return;
			}

			$document->start_controls_section(
				'test_section',
				[
					'label' => esc_html__('Test Section', 'trackngo-core'),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$document->add_control(
				'cls',
				[
					'label' => esc_html__('Body class', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'options' => [
						'personal_therapist' => esc_html__('Home', 'trackngo-core'),
						'mental_health'  => esc_html__('Mental Health', 'trackngo-core'),
						'demo_counceling' => esc_html__('Counceling', 'trackngo-core'),
					],
				]
			);

			$document->end_controls_section();
		}

		// ========= COMMON Typography STYLES ==========
		public function typography_style($wb, $section_title, $selector)
		{
			$section_id = str_replace(' ', '', $section_title);

			$wb->start_controls_section(
				$section_id,
				[
					'label' => $section_title,
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);

			$wb->add_control(
				$section_id . 'clr',
				[
					'label' => esc_html__('Color', 'trackngo-core'),
					'type'  => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'color: {{VALUE}} !important;',
					],
				]
			);
			$wb->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => $section_id . 'typ',
					'label' => __('Typography', 'trackngo-core'),
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);

			$wb->add_group_control(
				\Elementor\Group_Control_Text_Shadow::get_type(),
				[
					'name' => $section_id . 'text_shadow',
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);

			$wb->add_group_control(
				\Elementor\Group_Control_Text_Stroke::get_type(),
				[
					'name' => $section_id . 'text_stroke',
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);
			$wb->add_control(
				$section_id . 'title_align',
				[
					'label' => esc_html__('Alignment', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__('Left', 'trackngo-core'),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__('Center', 'trackngo-core'),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__('Right', 'trackngo-core'),
							'icon' => 'eicon-text-align-right',
						],
					],
					// 'default' => 'center',
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'text-align: {{VALUE}};',
					],
				]
			);
			$wb->add_control(
				$section_id . 'margin',
				[
					'label' => esc_html__('margin', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em', 'rem', 'custom'],
					'default' => [
						'unit' => 'em',
						'isLinked' => false,
					],
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'devices' => ['desktop', 'tablet', 'mobile'],
				]
			);
			$wb->add_control(
				$section_id . 'padding',
				[
					'label' => esc_html__('Padding', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em', 'rem', 'custom'],
					'default' => [
						'unit' => 'em',
						'isLinked' => false,
					],
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'devices' => ['desktop', 'tablet', 'mobile'],
				]
			);
			$wb->end_controls_section();
		}

		// ========= COMMON BUTTON STYLES ==========
		public function button_style($wb, $section_title, $selector)
		{
			$section_id = str_replace(' ', '', $section_title);

			$wb->start_controls_section(
				$section_id,
				[
					'label' => $section_title,
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			// START TABS
			$wb->start_controls_tabs($section_id . '_tabs');
			/* ---------------- Normal Tab ---------------- */
			$wb->add_control(
				$section_id . 'btn_align',
				[
					'label' => esc_html__('Alignment Horizontal', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => esc_html__('Left', 'trackngo-core'),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__('Center', 'trackngo-core'),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__('Right', 'trackngo-core'),
							'icon' => 'eicon-text-align-right',
						],
					],
					// 'default' => 'center',
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .main-button a' => 'display: flex;',
						'{{WRAPPER}} .main-button' => 'display: flex;',
						'{{WRAPPER}} .main-button a' => 'justify-content: {{VALUE}};',
						'{{WRAPPER}} .main-button' => 'justify-content: {{VALUE}};',
					],
				]
			);
			
			$wb->start_controls_tab(
				$section_id . '_normal',
				[
					'label' => esc_html__('Normal', 'trackngo-core'),
				]
			);
			$wb->add_control(
				$section_id . '_text_color',
				[
					'label' => esc_html__('Text Color', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'color: {{VALUE}}',
					],
				]
			);
			$wb->add_control(
				$section_id . '__bg_color',
				[
					'label' => esc_html__('Background Color', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'background: {{VALUE}}',
					],
				]
			);
			$wb->add_control(
				$section_id . '_icon_color',
				[
					'label' => esc_html__('Icon Color', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .arrow-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$wb->add_control(
				$section_id . '_icon_bg_color',
				[
					'label' => esc_html__('Icon Background', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .arrow-btn' => 'background: {{VALUE}}',
					],
				]
			);
			$wb->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => $section_id . '_typography',
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);
			$wb->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => $section_id . '_border',
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);
			$wb->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => $section_id . '_box_shadow',
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);
			$wb->add_control(
				$section_id . '_border_radius',
				[
					'label' => esc_html__('Border Radius', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em', 'rem', 'custom'],
					'default' => [
						'unit' => 'em',
						'isLinked' => false,
					],
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$wb->add_control(
				$section_id . '_padding',
				[
					'label' => esc_html__('Padding', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em', 'rem', 'custom'],
					'default' => [
						'unit' => 'em',
						'isLinked' => false,
					],
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$wb->end_controls_tab();

			/* ---------------- Hover Tab ---------------- */
			$wb->start_controls_tab(
				$section_id . '_hover',
				[
					'label' => esc_html__('Hover', 'trackngo-core'),
				]
			);



			$wb->add_control(
				$section_id . '_text_hover_color',
				[
					'label' => esc_html__('Text Color', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .main-button a:hover' . $selector  => 'color: {{VALUE}}',
					],
				]
			);
			$wb->add_control(
				$section_id . '_bg_hover_color',
				[
					'label' => esc_html__('Background', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .main-button a:hover .theme-btn' => 'background: {{VALUE}}',
						'{{WRAPPER}} ' . $selector => 'background: {{VALUE}}',
					],
				]
			);
			$wb->add_control(
				$section_id . '_icon_color_hover',
				[
					'label' => esc_html__('Icon Color', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .main-button a:hover .arrow-btn' => 'color: {{VALUE}}',
					],
				]
			);
			$wb->add_control(
				$section_id . '_icon_bg_color_hover',
				[
					'label' => esc_html__('Icon Background', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .main-button a:hover .arrow-btn' => 'background: {{VALUE}}',
					],
				]
			);
			$wb->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => $section_id . '_border_hover',
					'selector' => '{{WRAPPER}} ' . $selector . ':hover',
				]
			);

			$wb->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => $section_id . '_shadow_hover',
					'selector' => '{{WRAPPER}} ' . $selector . ':hover',
				]
			);
			$wb->end_controls_tab();
			$wb->end_controls_tabs();
			$wb->end_controls_section();
		}

		// =========	SECTION STYLES ==========
		public function section_style($wb, $section_title, $selector)
		{
			$section_id = str_replace(' ', '', $section_title);

			$wb->start_controls_section(
				$section_id . '_sec',
				[
					'label' => $section_title,
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$wb->add_group_control(
				\Elementor\Group_Control_Background::get_type(),
				[
					'name' => $section_id . '_sec_bg',
					'types' => ['classic', 'gradient', 'video'],
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);
			$wb->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' => $section_id . 'sec_border',
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);
			$wb->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' => $section_id . 'sec_box_shadow',
					'selector' => '{{WRAPPER}} ' . $selector,
				]
			);
			$wb->add_control(
				$section_id . 'border_radius',
				[
					'label' => esc_html__('Border Radius', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em', 'rem', 'custom'],
					'default' => [
						'unit' => 'em',
						'isLinked' => false,
					],
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$wb->add_control(
				$section_id . 'margin',
				[
					'label' => esc_html__('Margin', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em', 'rem', 'custom'],
					'default' => [
						'unit' => 'em',
						'isLinked' => false,
					],
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$wb->add_control(
				$section_id . 'padding',
				[
					'label' => esc_html__('Padding', 'trackngo-core'),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => ['px', '%', 'em', 'rem', 'custom'],
					'default' => [
						'unit' => 'em',
						'isLinked' => false,
					],
					'selectors' => [
						'{{WRAPPER}} ' . $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$wb->end_controls_section();
		}
	}

	Trackngo_Elementor_Widget_Init::getInstance();
}
